/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.funzy;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jooby.funzy.Throwing;

public abstract class Try {
    public static final <R extends AutoCloseable> ResourceHandler<R> of(R r1) {
        return Try.with(() -> r1);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable> ResourceHandler2<R1, R2> of(R1 r1, R2 r2) {
        return Try.with(() -> r1, () -> r2);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable> ResourceHandler3<R1, R2, R3> of(R1 r1, R2 r2, R3 r3) {
        return Try.with(() -> r1, () -> r2, () -> r3);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable, R4 extends AutoCloseable> ResourceHandler4<R1, R2, R3, R4> of(R1 r1, R2 r2, R3 r3, R4 r4) {
        return Try.with(() -> r1, () -> r2, () -> r3, () -> r4);
    }

    public static final <R extends AutoCloseable> ResourceHandler<R> with(Throwing.Supplier<R> r1) {
        return new ResourceHandler(r1);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable> ResourceHandler2<R1, R2> with(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2) {
        return new ResourceHandler2(r1, r2);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable> ResourceHandler3<R1, R2, R3> with(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2, Throwing.Supplier<R3> r3) {
        return new ResourceHandler3(r1, r2, r3);
    }

    public static final <R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable, R4 extends AutoCloseable> ResourceHandler4<R1, R2, R3, R4> with(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2, Throwing.Supplier<R3> r3, Throwing.Supplier<R4> r4) {
        return new ResourceHandler4(r1, r2, r3, r4);
    }

    public static final <V> Value<V> success(V value) {
        return new Success<V>(value);
    }

    public static final Value<Throwable> failure(Throwable x) {
        return new Failure<Throwable>(x);
    }

    public static <V> Value<V> apply(Throwing.Supplier<? extends V> fn) {
        try {
            return new Success<V>(fn.get());
        }
        catch (Throwable x) {
            return new Failure(x);
        }
    }

    public static <V> Value<V> call(Callable<? extends V> fn) {
        return Try.apply(fn::call);
    }

    public static Try run(Throwing.Runnable runnable) {
        try {
            runnable.run();
            return new Success<Object>(null);
        }
        catch (Throwable x) {
            return new Failure(x);
        }
    }

    public boolean isFailure() {
        return this.getCause().isPresent();
    }

    public boolean isSuccess() {
        return !this.isFailure();
    }

    public Try onFailure(Consumer<? super Throwable> action) {
        this.getCause().ifPresent(action);
        return this;
    }

    public Try onSuccess(Runnable action) {
        if (this.isSuccess()) {
            action.run();
        }
        return this;
    }

    public <X extends Throwable> Try unwrap(Class<? extends X> type) {
        return this.unwrap(type::isInstance);
    }

    public Try unwrap(Throwing.Predicate<Throwable> predicate) {
        try {
            return this.getCause().filter(predicate).map(Throwable::getCause).filter(Objects::nonNull).map(x -> Try.failure(x)).orElse(this);
        }
        catch (Throwable x2) {
            return Try.failure(x2);
        }
    }

    public Try wrap(Throwing.Function<Throwable, Throwable> wrapper) {
        return this.wrap(Throwable.class, wrapper);
    }

    public <X extends Throwable> Try wrap(Class<? extends X> predicate, Throwing.Function<X, Throwable> wrapper) {
        return this.wrap(predicate::isInstance, wrapper);
    }

    public <X extends Throwable> Try wrap(Throwing.Predicate<X> predicate, Throwing.Function<X, Throwable> wrapper) {
        try {
            return this.getCause().filter(x -> predicate.test((Object)x)).map(x -> Try.failure((Throwable)wrapper.apply((Object)x))).orElse(this);
        }
        catch (Throwable x2) {
            return Try.failure(x2);
        }
    }

    public Try onComplete(Throwing.Runnable action) {
        try {
            action.run();
            return this;
        }
        catch (Throwable x) {
            return Try.failure(x);
        }
    }

    public Try onComplete(Throwing.Consumer<Throwable> action) {
        try {
            action.accept((Throwable)this.getCause().orElse(null));
            return this;
        }
        catch (Throwable x) {
            return Try.failure(x);
        }
    }

    public void throwException() {
        this.getCause().ifPresent(Throwing::sneakyThrow);
    }

    public abstract Optional<Throwable> getCause();

    public static class ResourceHandler4<R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable, R4 extends AutoCloseable> {
        private final Throwing.Supplier<R1> r1;
        private final Throwing.Supplier<R2> r2;
        private final Throwing.Supplier<R3> r3;
        private final Throwing.Supplier<R4> r4;

        private ResourceHandler4(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2, Throwing.Supplier<R3> r3, Throwing.Supplier<R4> r4) {
            this.r1 = r1;
            this.r2 = r2;
            this.r3 = r3;
            this.r4 = r4;
        }

        public <V> Value<V> apply(Throwing.Function4<R1, R2, R3, R4, V> fn) {
            return Try.apply(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }

        public Try run(Throwing.Consumer4<R1, R2, R3, R4> fn) {
            return Try.run(() -> {
                try (AutoCloseable r1 = (AutoCloseable)this.r1.get();
                     AutoCloseable r2 = (AutoCloseable)this.r2.get();
                     AutoCloseable r3 = (AutoCloseable)this.r3.get();
                     AutoCloseable r4 = (AutoCloseable)this.r4.get();){
                    fn.accept(r1, r2, r3, r4);
                }
            });
        }
    }

    public static class ResourceHandler3<R1 extends AutoCloseable, R2 extends AutoCloseable, R3 extends AutoCloseable> {
        private final Throwing.Supplier<R1> r1;
        private final Throwing.Supplier<R2> r2;
        private final Throwing.Supplier<R3> r3;

        private ResourceHandler3(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2, Throwing.Supplier<R3> r3) {
            this.r1 = r1;
            this.r2 = r2;
            this.r3 = r3;
        }

        public <V> Value<V> apply(Throwing.Function3<R1, R2, R3, V> fn) {
            return Try.apply(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }

        public Try run(Throwing.Consumer3<R1, R2, R3> fn) {
            return Try.run(() -> {
                try (AutoCloseable r1 = (AutoCloseable)this.r1.get();
                     AutoCloseable r2 = (AutoCloseable)this.r2.get();
                     AutoCloseable r3 = (AutoCloseable)this.r3.get();){
                    fn.accept(r1, r2, r3);
                }
            });
        }
    }

    public static class ResourceHandler2<R1 extends AutoCloseable, R2 extends AutoCloseable> {
        private final Throwing.Supplier<R1> r1;
        private final Throwing.Supplier<R2> r2;

        private ResourceHandler2(Throwing.Supplier<R1> r1, Throwing.Supplier<R2> r2) {
            this.r1 = r1;
            this.r2 = r2;
        }

        public <V> Value<V> apply(Throwing.Function2<R1, R2, V> fn) {
            return Try.apply(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }

        public Try run(Throwing.Consumer2<R1, R2> fn) {
            return Try.run(() -> {
                try (AutoCloseable r1 = (AutoCloseable)this.r1.get();
                     AutoCloseable r2 = (AutoCloseable)this.r2.get();){
                    fn.accept(r1, r2);
                }
            });
        }
    }

    public static class ResourceHandler<R extends AutoCloseable> {
        private final Throwing.Supplier<R> r;

        private ResourceHandler(Throwing.Supplier<R> r1) {
            this.r = r1;
        }

        public <V extends AutoCloseable> ResourceHandler<V> map(Throwing.Function<R, V> fn) {
            return new ResourceHandler<R>(new ProxyCloseable<R, V>(this.r, fn));
        }

        public <V> Value<V> apply(Throwing.Function<R, V> fn) {
            return Try.apply(() -> {
                try (AutoCloseable r1 = (AutoCloseable)this.r.get();){
                    if (r1 instanceof ProxyCloseable) {
                        Object r = fn.apply((R)((ProxyCloseable)r1).resource);
                        return r;
                    }
                    Object r = fn.apply((R)r1);
                    return r;
                }
            });
        }

        public Try run(Throwing.Consumer<R> fn) {
            return Try.run(() -> {
                try (AutoCloseable r1 = (AutoCloseable)this.r.get();){
                    fn.accept((R)r1);
                }
            });
        }

        private static class ProxyCloseable<P extends AutoCloseable, R extends AutoCloseable>
        implements AutoCloseable,
        Throwing.Supplier<R> {
            private final Throwing.Supplier<P> parent;
            private final Throwing.Function<P, R> mapper;
            private P parentResource;
            private R resource;

            public ProxyCloseable(Throwing.Supplier<P> parent, Throwing.Function<P, R> mapper) {
                this.parent = parent;
                this.mapper = mapper;
            }

            @Override
            public void close() throws Exception {
                try {
                    Optional.ofNullable(this.resource).ifPresent(Throwing.throwingConsumer(AutoCloseable::close));
                }
                finally {
                    if (this.parent instanceof ProxyCloseable) {
                        ((ProxyCloseable)this.parent).close();
                    } else {
                        Optional.ofNullable(this.parentResource).ifPresent(Throwing.throwingConsumer(AutoCloseable::close));
                    }
                }
            }

            @Override
            public R tryGet() throws Throwable {
                if (this.parent instanceof ProxyCloseable) {
                    ProxyCloseable proxy = (ProxyCloseable)this.parent;
                    if (proxy.resource == null) {
                        proxy.get();
                    }
                    this.parentResource = proxy.resource;
                } else {
                    this.parentResource = (AutoCloseable)this.parent.get();
                }
                this.resource = (AutoCloseable)this.mapper.apply(this.parentResource);
                return (R)this;
            }
        }
    }

    private static class Failure<V>
    extends Value<V> {
        private final Throwable x;

        public Failure(Throwable x) {
            this.x = x;
        }

        @Override
        public V get() {
            throw Throwing.sneakyThrow(this.x);
        }

        @Override
        public Optional<Throwable> getCause() {
            return Optional.of(this.x);
        }
    }

    private static class Success<V>
    extends Value<V> {
        private final V value;

        public Success(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public Optional<Throwable> getCause() {
            return Optional.empty();
        }
    }

    public static abstract class Value<V>
    extends Try {
        public abstract V get();

        public V orElseGet(Supplier<V> value) {
            return this.isSuccess() ? this.get() : value.get();
        }

        public V orElse(V value) {
            return this.isSuccess() ? this.get() : value;
        }

        public V orElseThrow(Throwing.Function<Throwable, Throwable> provider) {
            if (this.isSuccess()) {
                return this.get();
            }
            throw Throwing.sneakyThrow(provider.apply(this.getCause().get()));
        }

        @Override
        public Value<V> onComplete(Throwing.Runnable action) {
            return (Value)super.onComplete(action);
        }

        @Override
        public Value<V> onComplete(Throwing.Consumer<Throwable> action) {
            return (Value)super.onComplete(action);
        }

        public Value<V> onComplete(Throwing.Consumer2<V, Throwable> action) {
            try {
                Object value = this.isSuccess() ? (Object)this.get() : null;
                action.accept(value, this.getCause().orElse(null));
                return this;
            }
            catch (Throwable x) {
                return Value.failure(x);
            }
        }

        @Override
        public Value<V> onFailure(Consumer<? super Throwable> action) {
            super.onFailure(action);
            return this;
        }

        @Override
        public Value<V> onSuccess(Runnable action) {
            super.onSuccess(action);
            return this;
        }

        public Value<V> onSuccess(Consumer<V> action) {
            if (this.isSuccess()) {
                action.accept(this.get());
            }
            return this;
        }

        public Value<V> recoverWith(Throwing.Function<Throwable, Value<V>> fn) {
            return this.recoverWith(Throwable.class, fn);
        }

        public <X extends Throwable> Value<V> recoverWith(Class<X> exception, Throwing.Function<X, Value<V>> fn) {
            return this.getCause().filter(exception::isInstance).map((? super T x) -> {
                try {
                    return (Value)fn.apply((Object)x);
                }
                catch (Throwable ex) {
                    return Value.failure(ex);
                }
            }).orElse(this);
        }

        public Value<V> recover(Throwing.Function<Throwable, V> fn) {
            return this.recover(Throwable.class, fn);
        }

        public <X extends Throwable> Value<V> recover(Class<X> exception, V value) {
            return this.recoverWith(exception, x -> Try.success(value));
        }

        public <X extends Throwable> Value<V> recover(Class<X> exception, Throwing.Function<X, V> fn) {
            return this.recoverWith(exception, x -> Try.apply(() -> fn.apply((Object)x)));
        }

        public <T> Value<T> flatMap(Throwing.Function<V, Value<T>> mapper) {
            if (this.isFailure()) {
                return this;
            }
            try {
                return mapper.apply(this.get());
            }
            catch (Throwable x) {
                return new Failure(x);
            }
        }

        public <T> Value<T> map(Throwing.Function<V, T> mapper) {
            return this.flatMap(v -> new Success(mapper.apply((Object)v)));
        }

        public Optional<V> toOptional() {
            return this.isFailure() ? Optional.empty() : Optional.ofNullable(this.get());
        }

        @Override
        public <X extends Throwable> Value<V> unwrap(Class<? extends X> type) {
            return (Value)super.unwrap(type);
        }

        @Override
        public Value<V> unwrap(Throwing.Predicate<Throwable> predicate) {
            return (Value)super.unwrap(predicate);
        }

        @Override
        public Value<V> wrap(Throwing.Function<Throwable, Throwable> wrapper) {
            return (Value)super.wrap(wrapper);
        }

        @Override
        public <X extends Throwable> Value<V> wrap(Class<? extends X> predicate, Throwing.Function<X, Throwable> wrapper) {
            return (Value)super.wrap(predicate, wrapper);
        }

        @Override
        public <X extends Throwable> Value<V> wrap(Throwing.Predicate<X> predicate, Throwing.Function<X, Throwable> wrapper) {
            return (Value)super.wrap(predicate, wrapper);
        }
    }
}

