/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import org.jooby.Cookie;
import org.jooby.Mutant;

public interface Session {
    public static final String COOKIE_SESSION = "cookieSession";

    @Nonnull
    public String id();

    public long createdAt();

    public long savedAt();

    public long accessedAt();

    public long expiryAt();

    @Nonnull
    public Mutant get(String var1);

    @Nonnull
    public Map<String, String> attributes();

    public boolean isSet(String var1);

    @Nonnull
    default public Session set(String name, byte value) {
        return this.set(name, Byte.toString(value));
    }

    @Nonnull
    default public Session set(String name, char value) {
        return this.set(name, Character.toString(value));
    }

    @Nonnull
    default public Session set(String name, boolean value) {
        return this.set(name, Boolean.toString(value));
    }

    @Nonnull
    default public Session set(String name, short value) {
        return this.set(name, Short.toString(value));
    }

    @Nonnull
    default public Session set(String name, int value) {
        return this.set(name, Integer.toString(value));
    }

    @Nonnull
    default public Session set(String name, long value) {
        return this.set(name, Long.toString(value));
    }

    @Nonnull
    default public Session set(String name, float value) {
        return this.set(name, Float.toString(value));
    }

    @Nonnull
    default public Session set(String name, double value) {
        return this.set(name, Double.toString(value));
    }

    @Nonnull
    default public Session set(String name, CharSequence value) {
        return this.set(name, value.toString());
    }

    @Nonnull
    public Session set(String var1, String var2);

    @Nonnull
    public Mutant unset(String var1);

    @Nonnull
    public Session unset();

    public void destroy();

    public boolean isDestroyed();

    public Session renewId();

    public static interface Builder {
        public String sessionId();

        public Builder set(String var1, String var2);

        public Builder set(Map<String, String> var1);

        public Builder createdAt(long var1);

        public Builder accessedAt(long var1);

        public Builder savedAt(long var1);

        public Session build();
    }

    public static class Mem
    implements Store {
        private ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>();

        @Override
        public void create(Session session) {
            this.sessions.putIfAbsent(session.id(), session);
        }

        @Override
        public void save(Session session) {
            this.sessions.put(session.id(), session);
        }

        @Override
        public Session get(Builder builder) {
            return (Session)this.sessions.get(builder.sessionId());
        }

        @Override
        public void delete(String id) {
            this.sessions.remove(id);
        }
    }

    public static interface Store {
        public static final SecureRandom rnd = new SecureRandom();

        public Session get(Builder var1);

        public void save(Session var1);

        public void create(Session var1);

        public void delete(String var1);

        default public String generateID() {
            byte[] bytes = new byte[30];
            rnd.nextBytes(bytes);
            return BaseEncoding.base64Url().encode(bytes);
        }
    }

    public static class Definition {
        private Object store;
        private Cookie.Definition cookie;
        private Long saveInterval;

        public Definition(Class<? extends Store> store) {
            this.store = Objects.requireNonNull(store, "A session store is required.");
            this.cookie = new Cookie.Definition();
        }

        Definition() {
            this.cookie = new Cookie.Definition();
        }

        public Definition(Store store) {
            this.store = Objects.requireNonNull(store, "A session store is required.");
            this.cookie = new Cookie.Definition();
        }

        public Optional<Long> saveInterval() {
            return Optional.ofNullable(this.saveInterval);
        }

        public Definition saveInterval(long saveInterval) {
            this.saveInterval = saveInterval;
            return this;
        }

        public Object store() {
            return this.store;
        }

        public Cookie.Definition cookie() {
            return this.cookie;
        }
    }

    public static class Destroyed
    extends RuntimeException {
        public Destroyed() {
            super("Session has been destroyed.");
        }
    }
}

