/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.jooby.Deferred;
import org.jooby.Err;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.Sse;
import org.jooby.Status;
import org.jooby.WebSocket;
import org.jooby.funzy.Try;
import org.jooby.handlers.AssetHandler;

public interface Router {
    public static String decode(String path) {
        return Try.apply(() -> URLDecoder.decode(path, "UTF-8")).get();
    }

    @Nonnull
    public Router use(Jooby var1);

    public Route.Collection path(String var1, Runnable var2);

    @Nonnull
    public Router use(String var1, Jooby var2);

    @Nonnull
    public Route.Definition use(String var1, Route.Filter var2);

    @Nonnull
    public Route.Definition use(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Definition use(String var1, String var2, Route.Handler var3);

    @Nonnull
    public Route.Definition use(String var1, Route.Handler var2);

    @Nonnull
    public Route.Definition use(String var1, Route.OneArgHandler var2);

    @Nonnull
    default public Route.Definition get(Route.Handler handler) {
        return this.get("/", handler);
    }

    @Nonnull
    public Route.Definition get(String var1, Route.Handler var2);

    @Nonnull
    public Route.Collection get(String var1, String var2, Route.Handler var3);

    @Nonnull
    public Route.Collection get(String var1, String var2, String var3, Route.Handler var4);

    @Nonnull
    default public Route.Definition get(Route.OneArgHandler handler) {
        return this.get("/", handler);
    }

    @Nonnull
    public Route.Definition get(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Collection get(String var1, String var2, Route.OneArgHandler var3);

    @Nonnull
    public Route.Collection get(String var1, String var2, String var3, Route.OneArgHandler var4);

    @Nonnull
    default public Route.Definition get(Route.ZeroArgHandler handler) {
        return this.get("/", handler);
    }

    @Nonnull
    public Route.Definition get(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Collection get(String var1, String var2, Route.ZeroArgHandler var3);

    @Nonnull
    public Route.Collection get(String var1, String var2, String var3, Route.ZeroArgHandler var4);

    @Nonnull
    public Route.Definition get(String var1, Route.Filter var2);

    @Nonnull
    public Route.Collection get(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Collection get(String var1, String var2, String var3, Route.Filter var4);

    @Nonnull
    default public Route.Definition post(Route.Handler handler) {
        return this.post("/", handler);
    }

    @Nonnull
    public Route.Definition post(String var1, Route.Handler var2);

    @Nonnull
    public Route.Collection post(String var1, String var2, Route.Handler var3);

    @Nonnull
    public Route.Collection post(String var1, String var2, String var3, Route.Handler var4);

    @Nonnull
    default public Route.Definition post(Route.OneArgHandler handler) {
        return this.post("/", handler);
    }

    @Nonnull
    public Route.Definition post(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Collection post(String var1, String var2, Route.OneArgHandler var3);

    @Nonnull
    public Route.Collection post(String var1, String var2, String var3, Route.OneArgHandler var4);

    @Nonnull
    default public Route.Definition post(Route.ZeroArgHandler handler) {
        return this.post("/", handler);
    }

    @Nonnull
    public Route.Definition post(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Collection post(String var1, String var2, Route.ZeroArgHandler var3);

    @Nonnull
    public Route.Collection post(String var1, String var2, String var3, Route.ZeroArgHandler var4);

    @Nonnull
    public Route.Definition post(String var1, Route.Filter var2);

    @Nonnull
    public Route.Collection post(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Collection post(String var1, String var2, String var3, Route.Filter var4);

    @Nonnull
    public Route.Definition head(String var1, Route.Handler var2);

    @Nonnull
    public Route.Definition head(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Definition head(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Definition head(String var1, Route.Filter var2);

    @Nonnull
    public Route.Definition head();

    @Nonnull
    public Route.Definition options(String var1, Route.Handler var2);

    @Nonnull
    public Route.Definition options(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Definition options(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Definition options(String var1, Route.Filter var2);

    @Nonnull
    public Route.Definition options();

    @Nonnull
    default public Route.Definition put(Route.Handler handler) {
        return this.put("/", handler);
    }

    @Nonnull
    public Route.Definition put(String var1, Route.Handler var2);

    @Nonnull
    public Route.Collection put(String var1, String var2, Route.Handler var3);

    @Nonnull
    public Route.Collection put(String var1, String var2, String var3, Route.Handler var4);

    @Nonnull
    default public Route.Definition put(Route.OneArgHandler handler) {
        return this.put("/", handler);
    }

    @Nonnull
    public Route.Definition put(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Collection put(String var1, String var2, Route.OneArgHandler var3);

    @Nonnull
    public Route.Collection put(String var1, String var2, String var3, Route.OneArgHandler var4);

    @Nonnull
    default public Route.Definition put(Route.ZeroArgHandler handler) {
        return this.put("/", handler);
    }

    @Nonnull
    public Route.Definition put(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Collection put(String var1, String var2, Route.ZeroArgHandler var3);

    @Nonnull
    public Route.Collection put(String var1, String var2, String var3, Route.ZeroArgHandler var4);

    @Nonnull
    public Route.Definition put(String var1, Route.Filter var2);

    @Nonnull
    public Route.Collection put(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Collection put(String var1, String var2, String var3, Route.Filter var4);

    @Nonnull
    default public Route.Definition patch(Route.Handler handler) {
        return this.patch("/", handler);
    }

    @Nonnull
    public Route.Definition patch(String var1, Route.Handler var2);

    @Nonnull
    public Route.Collection patch(String var1, String var2, Route.Handler var3);

    public Route.Collection patch(String var1, String var2, String var3, Route.Handler var4);

    @Nonnull
    default public Route.Definition patch(Route.OneArgHandler handler) {
        return this.patch("/", handler);
    }

    @Nonnull
    public Route.Definition patch(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Collection patch(String var1, String var2, Route.OneArgHandler var3);

    @Nonnull
    public Route.Collection patch(String var1, String var2, String var3, Route.OneArgHandler var4);

    @Nonnull
    default public Route.Definition patch(Route.ZeroArgHandler handler) {
        return this.patch("/", handler);
    }

    @Nonnull
    public Route.Definition patch(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Collection patch(String var1, String var2, Route.ZeroArgHandler var3);

    @Nonnull
    public Route.Collection patch(String var1, String var2, String var3, Route.ZeroArgHandler var4);

    @Nonnull
    public Route.Definition patch(String var1, Route.Filter var2);

    @Nonnull
    public Route.Collection patch(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Collection patch(String var1, String var2, String var3, Route.Filter var4);

    @Nonnull
    default public Route.Definition delete(Route.Handler handler) {
        return this.delete("/", handler);
    }

    @Nonnull
    public Route.Definition delete(String var1, Route.Handler var2);

    @Nonnull
    public Route.Collection delete(String var1, String var2, Route.Handler var3);

    @Nonnull
    public Route.Collection delete(String var1, String var2, String var3, Route.Handler var4);

    @Nonnull
    default public Route.Definition delete(Route.OneArgHandler handler) {
        return this.delete("/", handler);
    }

    @Nonnull
    public Route.Definition delete(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Collection delete(String var1, String var2, Route.OneArgHandler var3);

    @Nonnull
    public Route.Collection delete(String var1, String var2, String var3, Route.OneArgHandler var4);

    @Nonnull
    default public Route.Definition delete(Route.ZeroArgHandler handler) {
        return this.delete("/", handler);
    }

    @Nonnull
    public Route.Definition delete(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Collection delete(String var1, String var2, Route.ZeroArgHandler var3);

    @Nonnull
    public Route.Collection delete(String var1, String var2, String var3, Route.ZeroArgHandler var4);

    @Nonnull
    public Route.Definition delete(String var1, Route.Filter var2);

    @Nonnull
    public Route.Collection delete(String var1, String var2, Route.Filter var3);

    @Nonnull
    public Route.Collection delete(String var1, String var2, String var3, Route.Filter var4);

    @Nonnull
    public Route.Definition trace(String var1, Route.Handler var2);

    @Nonnull
    public Route.Definition trace(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Definition trace(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Definition trace(String var1, Route.Filter var2);

    @Nonnull
    public Route.Definition trace();

    @Nonnull
    public Route.Definition connect(String var1, Route.Handler var2);

    @Nonnull
    public Route.Definition connect(String var1, Route.OneArgHandler var2);

    @Nonnull
    public Route.Definition connect(String var1, Route.ZeroArgHandler var2);

    @Nonnull
    public Route.Definition connect(String var1, Route.Filter var2);

    @Nonnull
    default public Route.AssetDefinition assets(String path) {
        return this.assets(path, "/");
    }

    @Nonnull
    public Route.AssetDefinition assets(String var1, Path var2);

    @Nonnull
    public Route.AssetDefinition assets(String var1, String var2);

    @Nonnull
    public Route.AssetDefinition assets(String var1, AssetHandler var2);

    @Nonnull
    public Route.Collection use(Class<?> var1);

    @Nonnull
    public Route.Collection use(String var1, Class<?> var2);

    @Nonnull
    default public Route.Definition before(Route.Before handler) {
        return this.before("*", handler);
    }

    @Nonnull
    default public Route.Collection before(Route.Before handler, Route.Before ... next) {
        return this.before("*", handler, next);
    }

    @Nonnull
    default public Route.Definition before(String pattern, Route.Before handler) {
        return this.before("*", pattern, handler);
    }

    @Nonnull
    default public Route.Collection before(String pattern, Route.Before handler, Route.Before ... next) {
        return this.before("*", pattern, handler, next);
    }

    @Nonnull
    public Route.Definition before(String var1, String var2, Route.Before var3);

    @Nonnull
    default public Route.Collection before(String method, String pattern, Route.Before handler, Route.Before ... next) {
        ArrayList<Route.Definition> routes = new ArrayList<Route.Definition>();
        routes.add(this.before(method, pattern, handler));
        Arrays.asList(next).stream().map((? super T h2) -> this.before(method, pattern, (Route.Before)h2)).forEach(routes::add);
        return new Route.Collection(routes.toArray(new Route.Definition[routes.size()]));
    }

    @Nonnull
    default public Route.Definition after(Route.After handler) {
        return this.after("*", handler);
    }

    @Nonnull
    default public Route.Collection after(Route.After handler, Route.After ... next) {
        return this.after("*", handler, next);
    }

    @Nonnull
    default public Route.Definition after(String pattern, Route.After handler) {
        return this.after("*", pattern, handler);
    }

    @Nonnull
    default public Route.Collection after(String pattern, Route.After handler, Route.After ... next) {
        return this.after("*", pattern, handler, next);
    }

    @Nonnull
    public Route.Definition after(String var1, String var2, Route.After var3);

    @Nonnull
    default public Route.Collection after(String method, String pattern, Route.After handler, Route.After ... next) {
        ArrayList<Route.Definition> routes = new ArrayList<Route.Definition>();
        routes.add(this.after(method, pattern, handler));
        Arrays.asList(next).stream().map((? super T h2) -> this.after(method, pattern, handler)).forEach(routes::add);
        return new Route.Collection(routes.toArray(new Route.Definition[routes.size()]));
    }

    @Nonnull
    default public Route.Definition complete(Route.Complete handler) {
        return this.complete("*", handler);
    }

    @Nonnull
    default public Route.Collection complete(Route.Complete handler, Route.Complete ... next) {
        return this.complete("*", handler, next);
    }

    @Nonnull
    default public Route.Definition complete(String pattern, Route.Complete handler) {
        return this.complete("*", pattern, handler);
    }

    @Nonnull
    default public Route.Collection complete(String pattern, Route.Complete handler, Route.Complete ... next) {
        return this.complete("*", pattern, handler, next);
    }

    @Nonnull
    public Route.Definition complete(String var1, String var2, Route.Complete var3);

    @Nonnull
    default public Route.Collection complete(String method, String pattern, Route.Complete handler, Route.Complete ... next) {
        ArrayList<Route.Definition> routes = new ArrayList<Route.Definition>();
        routes.add(this.complete(method, pattern, handler));
        Arrays.asList(next).stream().map((? super T h2) -> this.complete(method, pattern, handler)).forEach(routes::add);
        return new Route.Collection(routes.toArray(new Route.Definition[routes.size()]));
    }

    @Nonnull
    default public WebSocket.Definition ws(String path, WebSocket.OnOpen1 handler) {
        return this.ws(path, (WebSocket.OnOpen)handler);
    }

    @Nonnull
    public WebSocket.Definition ws(String var1, WebSocket.OnOpen var2);

    @Nonnull
    default public <T> WebSocket.Definition ws(Class<? extends WebSocket.OnMessage<T>> handler) {
        return this.ws("", handler);
    }

    @Nonnull
    public <T> WebSocket.Definition ws(String var1, Class<? extends WebSocket.OnMessage<T>> var2);

    @Nonnull
    public Route.Definition sse(String var1, Sse.Handler var2);

    @Nonnull
    public Route.Definition sse(String var1, Sse.Handler1 var2);

    @Nonnull
    public Route.Collection with(Runnable var1);

    @Nonnull
    public Router map(Route.Mapper<?> var1);

    @Nonnull
    public Router err(Err.Handler var1);

    @Nonnull
    default public Router err(Class<? extends Throwable> type, Err.Handler handler) {
        return this.err((req, rsp, x) -> {
            if (type.isInstance(x) || type.isInstance(x.getCause())) {
                handler.handle(req, rsp, x);
            }
        });
    }

    @Nonnull
    default public Router err(int statusCode, Err.Handler handler) {
        return this.err((req, rsp, x) -> {
            if (statusCode == x.statusCode()) {
                handler.handle(req, rsp, x);
            }
        });
    }

    @Nonnull
    default public Router err(Status code, Err.Handler handler) {
        return this.err((req, rsp, x) -> {
            if (code.value() == x.statusCode()) {
                handler.handle(req, rsp, x);
            }
        });
    }

    @Nonnull
    default public Router err(Predicate<Status> predicate, Err.Handler handler) {
        return this.err((req, rsp, err) -> {
            if (predicate.test(Status.valueOf(err.statusCode()))) {
                handler.handle(req, rsp, err);
            }
        });
    }

    @Nonnull
    public Route.OneArgHandler promise(Deferred.Initializer var1);

    @Nonnull
    public Route.OneArgHandler promise(String var1, Deferred.Initializer var2);

    @Nonnull
    public Route.OneArgHandler promise(Deferred.Initializer0 var1);

    @Nonnull
    public Route.OneArgHandler promise(String var1, Deferred.Initializer0 var2);

    @Nonnull
    default public Route.ZeroArgHandler deferred(String executor, Route.OneArgHandler handler) {
        return () -> Deferred.deferred(executor, handler);
    }

    @Nonnull
    default public Route.ZeroArgHandler deferred(Route.OneArgHandler handler) {
        return () -> Deferred.deferred(handler);
    }

    @Nonnull
    default public Route.ZeroArgHandler deferred(String executor, Route.ZeroArgHandler handler) {
        return () -> Deferred.deferred(executor, handler);
    }

    @Nonnull
    default public Route.ZeroArgHandler deferred(Route.ZeroArgHandler handler) {
        return () -> Deferred.deferred(handler);
    }
}

