/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Status;

public class Result {
    private static Map<String, Object> NO_HEADERS = ImmutableMap.of();
    protected Map<String, Object> headers = NO_HEADERS;
    protected Status status;
    protected MediaType type;
    private Object value;

    @Nonnull
    public Result status(Status status) {
        this.status = Objects.requireNonNull(status, "A status is required.");
        return this;
    }

    @Nonnull
    public Result status(int status) {
        return this.status(Status.valueOf(status));
    }

    @Nonnull
    public Result type(MediaType type) {
        this.type = Objects.requireNonNull(type, "A content type is required.");
        return this;
    }

    @Nonnull
    public Result type(String type) {
        return this.type(MediaType.valueOf(type));
    }

    @Nonnull
    public Result set(Object content) {
        this.value = content;
        return this;
    }

    @Nonnull
    public Result when(String type, Supplier<Object> supplier) {
        return this.when(MediaType.valueOf(type), supplier);
    }

    @Nonnull
    public Result when(MediaType type, Supplier<Object> supplier) {
        return new ContentNegotiation(this).when(type, supplier);
    }

    @Nonnull
    public Map<String, Object> headers() {
        return this.headers;
    }

    @Nonnull
    public Optional<Status> status() {
        return Optional.ofNullable(this.status);
    }

    @Nonnull
    public Optional<MediaType> type() {
        return Optional.ofNullable(this.type);
    }

    @Nonnull
    public Optional<Object> ifGet() {
        return this.ifGet(MediaType.ALL);
    }

    @Nullable
    public <T> T get() {
        return (T)this.value;
    }

    @Nonnull
    public Optional<Object> ifGet(List<MediaType> types) {
        return Optional.ofNullable(this.value);
    }

    @Nullable
    public <T> T get(List<MediaType> types) {
        return (T)this.value;
    }

    @Nonnull
    public Result header(String name, Object value) {
        Objects.requireNonNull(name, "Header's name is required.");
        Objects.requireNonNull(value, "Header's value is required.");
        this.setHeader(name, value);
        return this;
    }

    @Nonnull
    public Result header(String name, Object ... values) {
        Objects.requireNonNull(name, "Header's name is required.");
        Objects.requireNonNull(values, "Header's values are required.");
        return this.header(name, ImmutableList.copyOf(values));
    }

    @Nonnull
    public Result header(String name, Iterable<Object> values) {
        Objects.requireNonNull(name, "Header's name is required.");
        Objects.requireNonNull(values, "Header's values are required.");
        this.setHeader(name, values);
        return this;
    }

    protected Result clone() {
        Result result = new Result();
        this.headers.forEach(result::header);
        result.status = this.status;
        result.type = this.type;
        result.value = this.value;
        return result;
    }

    private void setHeader(String name, Object val) {
        this.headers = ImmutableMap.builder().putAll(this.headers).put(name, val).build();
    }

    static class ContentNegotiation
    extends Result {
        private final Map<MediaType, Supplier<Object>> data = new LinkedHashMap<MediaType, Supplier<Object>>();

        ContentNegotiation(Result result) {
            this.status = result.status;
            this.type = result.type;
            this.headers = result.headers;
        }

        @Override
        public <T> T get() {
            return this.get(MediaType.ALL);
        }

        @Override
        public Optional<Object> ifGet() {
            return this.ifGet(MediaType.ALL);
        }

        @Override
        public Optional<Object> ifGet(List<MediaType> types) {
            return Optional.ofNullable(this.get(types));
        }

        @Override
        public <T> T get(List<MediaType> types) {
            Supplier provider = MediaType.matcher(types).first(ImmutableList.copyOf(this.data.keySet())).map(it -> this.data.remove(it)).orElseThrow(() -> new Err(Status.NOT_ACCEPTABLE, Joiner.on(", ").join(types)));
            return provider.get();
        }

        @Override
        public Result when(MediaType type, Supplier<Object> supplier) {
            Objects.requireNonNull(type, "A media type is required.");
            Objects.requireNonNull(supplier, "A supplier fn is required.");
            this.data.put(type, supplier);
            return this;
        }

        @Override
        protected Result clone() {
            ContentNegotiation result = new ContentNegotiation(this);
            result.data.putAll(this.data);
            return result;
        }
    }
}

