/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jooby.Err;

public class MediaType
implements Comparable<MediaType> {
    private static final Map<String, String> DEFAULT_PARAMS = ImmutableMap.of("q", "1");
    public static final MediaType json = new MediaType("application", "json");
    private static final MediaType jsonLike = new MediaType("application", "*+json");
    public static final MediaType text = new MediaType("text", "*");
    public static final MediaType plain = new MediaType("text", "plain");
    public static final MediaType css = new MediaType("text", "css");
    public static final MediaType js = new MediaType("application", "javascript");
    public static final MediaType html = new MediaType("text", "html");
    public static final MediaType octetstream = new MediaType("application", "octet-stream");
    public static final MediaType all = new MediaType("*", "*");
    public static final List<MediaType> ALL = ImmutableList.of(all);
    public static final MediaType multipart = new MediaType("multipart", "form-data");
    public static final MediaType form = new MediaType("application", "x-www-form-urlencoded");
    public static final MediaType xml = new MediaType("application", "xml");
    public static final MediaType sse = new MediaType("text", "event-stream");
    private static final MediaType xmlLike = new MediaType("application", "*+xml");
    private final String type;
    private final String subtype;
    private final Map<String, String> params;
    private final boolean wildcardType;
    private final boolean wildcardSubtype;
    private String name;
    private int hc;
    private static final ConcurrentHashMap<String, List<MediaType>> cache = new ConcurrentHashMap();
    static final Config types;

    private MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = Objects.requireNonNull(type, "A mime type is required.");
        this.subtype = Objects.requireNonNull(subtype, "A mime subtype is required.");
        this.params = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "Parameters are required."));
        this.wildcardType = "*".equals(type);
        this.wildcardSubtype = "*".equals(subtype);
        this.name = type + "/" + subtype;
        this.hc = 31 + this.name.hashCode();
        this.hc = 31 * this.hc + this.params.hashCode();
    }

    private MediaType(String type, String subtype) {
        this(type, subtype, DEFAULT_PARAMS);
    }

    public float quality() {
        return Float.valueOf(this.params.get("q")).floatValue();
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public String subtype() {
        return this.subtype;
    }

    public String name() {
        return this.name;
    }

    public boolean isText() {
        if (this.wildcardType) {
            return false;
        }
        if (this == text || text.matches(this)) {
            return true;
        }
        if (this == js || js.matches(this)) {
            return true;
        }
        if (jsonLike.matches(this)) {
            return true;
        }
        if (xmlLike.matches(this)) {
            return true;
        }
        return this.type.equals("application") && this.subtype.equals("hocon");
    }

    @Override
    public int compareTo(MediaType that) {
        Objects.requireNonNull(that, "A media type is required.");
        if (this == that) {
            return 0;
        }
        if (this.wildcardType && !that.wildcardType) {
            return 1;
        }
        if (that.wildcardType && !this.wildcardType) {
            return -1;
        }
        if (this.wildcardSubtype && !that.wildcardSubtype) {
            return 1;
        }
        if (that.wildcardSubtype && !this.wildcardSubtype) {
            return -1;
        }
        if (!this.type().equals(that.type())) {
            return 0;
        }
        int q = Float.compare(that.quality(), this.quality());
        if (q != 0) {
            return q;
        }
        int paramsSize1 = this.params.size();
        int paramsSize2 = that.params.size();
        return paramsSize2 < paramsSize1 ? -1 : (paramsSize2 == paramsSize1 ? 0 : 1);
    }

    public boolean matches(MediaType that) {
        Objects.requireNonNull(that, "A media type is required.");
        if (this == that || this.wildcardType || that.wildcardType) {
            return true;
        }
        if (this.type.equals(that.type)) {
            if (this.subtype.equals(that.subtype) || this.wildcardSubtype || that.wildcardSubtype) {
                return true;
            }
            if (this.subtype.startsWith("*+")) {
                return that.subtype.endsWith(this.subtype.substring(2));
            }
            if (this.subtype.startsWith("*")) {
                return that.subtype.endsWith(this.subtype.substring(1));
            }
        }
        return false;
    }

    public boolean isAny() {
        return this.wildcardType && this.wildcardSubtype;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MediaType) {
            MediaType that = (MediaType)obj;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        return this.hc;
    }

    public final String toString() {
        return this.name;
    }

    public static MediaType valueOf(String type) throws Err.BadMediaType {
        return MediaType.parse(type).get(0);
    }

    private static List<MediaType> parseInternal(String value) {
        String[] types = value.split(",");
        ArrayList<MediaType> result = new ArrayList<MediaType>(types.length);
        for (String type : types) {
            String[] parts = type.trim().split(";");
            if (parts[0].equals("*")) {
                result.add(all);
                continue;
            }
            String[] typeAndSubtype = parts[0].split("/");
            if (typeAndSubtype.length != 2) {
                throw new Err.BadMediaType(value);
            }
            String stype = typeAndSubtype[0].trim();
            String subtype = typeAndSubtype[1].trim();
            if ("*".equals(stype) && !"*".equals(subtype)) {
                throw new Err.BadMediaType(value);
            }
            Map<String, String> parameters = DEFAULT_PARAMS;
            if (parts.length > 1) {
                parameters = new LinkedHashMap<String, String>(DEFAULT_PARAMS);
                for (int i = 1; i < parts.length; ++i) {
                    String[] parameter = parts[i].split("=");
                    if (parameter.length <= 1) continue;
                    parameters.put(parameter[0].trim(), parameter[1].trim().toLowerCase());
                }
            }
            result.add(new MediaType(stype, subtype, parameters));
        }
        if (result.size() > 1) {
            Collections.sort(result);
        }
        return result;
    }

    public static List<MediaType> valueOf(String ... types) throws Err.BadMediaType {
        Objects.requireNonNull(types, "Types are required.");
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        for (String type : types) {
            result.add(MediaType.valueOf(type));
        }
        return result;
    }

    public static List<MediaType> parse(String value) throws Err.BadMediaType {
        return cache.computeIfAbsent(value, MediaType::parseInternal);
    }

    public static Matcher matcher(MediaType acceptable) {
        return MediaType.matcher(ImmutableList.of(acceptable));
    }

    public static Matcher matcher(List<MediaType> acceptable) {
        Objects.requireNonNull(acceptable, "Acceptables media types are required.");
        return new Matcher(acceptable);
    }

    public static Optional<MediaType> byFile(File file) {
        Objects.requireNonNull(file, "A file is required.");
        return MediaType.byPath(file.getName());
    }

    public static Optional<MediaType> byPath(Path path) {
        Objects.requireNonNull(path, "A path is required.");
        return MediaType.byPath(path.toString());
    }

    public static Optional<MediaType> byPath(String path) {
        Objects.requireNonNull(path, "A path is required.");
        int idx = path.lastIndexOf(46);
        if (idx != -1) {
            String ext = path.substring(idx + 1);
            return MediaType.byExtension(ext);
        }
        return Optional.empty();
    }

    public static Optional<MediaType> byExtension(String ext) {
        Objects.requireNonNull(ext, "An ext is required.");
        String key = "mime." + ext;
        if (types.hasPath(key)) {
            return Optional.of(MediaType.valueOf(types.getString("mime." + ext)));
        }
        return Optional.empty();
    }

    static {
        cache.put("html", ImmutableList.of(html));
        cache.put("json", ImmutableList.of(json));
        cache.put("css", ImmutableList.of(css));
        cache.put("js", ImmutableList.of(js));
        cache.put("octetstream", ImmutableList.of(octetstream));
        cache.put("form", ImmutableList.of(form));
        cache.put("multipart", ImmutableList.of(multipart));
        cache.put("xml", ImmutableList.of(xml));
        cache.put("plain", ImmutableList.of(plain));
        cache.put("*", ALL);
        types = ConfigFactory.parseResources("mime.properties").withFallback(ConfigFactory.parseResources(MediaType.class, "mime.properties"));
    }

    public static class Matcher {
        private Iterable<MediaType> acceptable;

        Matcher(Iterable<MediaType> acceptable) {
            this.acceptable = acceptable;
        }

        public boolean matches(MediaType candidate) {
            return this.doFirst(ImmutableList.of(candidate)).isPresent();
        }

        public boolean matches(List<MediaType> candidates) {
            return this.filter(candidates).size() > 0;
        }

        public Optional<MediaType> first(MediaType candidate) {
            return this.first(ImmutableList.of(candidate));
        }

        public Optional<MediaType> first(List<MediaType> candidates) {
            return this.doFirst(candidates);
        }

        public List<MediaType> filter(List<MediaType> types) {
            AbstractCollection sortedTypes;
            Preconditions.checkArgument(types != null && types.size() > 0, "Media types are required");
            ImmutableList.Builder result = ImmutableList.builder();
            if (types.size() == 1) {
                sortedTypes = ImmutableList.of(types.get(0));
            } else {
                sortedTypes = new ArrayList<MediaType>(types);
                Collections.sort(sortedTypes);
            }
            for (MediaType accept : this.acceptable) {
                for (MediaType candidate : sortedTypes) {
                    if (!accept.matches(candidate)) continue;
                    result.add(candidate);
                }
            }
            return result.build();
        }

        private Optional<MediaType> doFirst(List<MediaType> candidates) {
            List<MediaType> result = this.filter(candidates);
            return result.size() == 0 ? Optional.empty() : Optional.of(result.get(0));
        }
    }
}

