/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jooby.Registry;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;

public interface LifeCycle {
    public static Optional<Throwing.Consumer<Object>> lifeCycleAnnotation(Class<?> rawType, Class<? extends Annotation> annotation) {
        for (Method method : rawType.getDeclaredMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods)) {
                throw new IllegalArgumentException(annotation.getSimpleName() + " method should not be static: " + method);
            }
            if (!Modifier.isPublic(mods)) {
                throw new IllegalArgumentException(annotation.getSimpleName() + " method must be public: " + method);
            }
            if (method.getParameterCount() > 0) {
                throw new IllegalArgumentException(annotation.getSimpleName() + " method should not accept arguments: " + method);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalArgumentException(annotation.getSimpleName() + " method should not return anything: " + method);
            }
            return Optional.of(owner -> Try.run(() -> {
                method.setAccessible(true);
                method.invoke(owner, new Object[0]);
            }).unwrap(InvocationTargetException.class).throwException());
        }
        return Optional.empty();
    }

    @Nonnull
    default public LifeCycle lifeCycle(Class<?> service) {
        LifeCycle.lifeCycleAnnotation(service, PostConstruct.class).ifPresent(it -> this.onStart((Registry app) -> it.accept(app.require(service))));
        LifeCycle.lifeCycleAnnotation(service, PreDestroy.class).ifPresent(it -> this.onStop((Registry app) -> it.accept(app.require(service))));
        return this;
    }

    @Nonnull
    public LifeCycle onStart(Throwing.Consumer<Registry> var1);

    @Nonnull
    public LifeCycle onStarted(Throwing.Consumer<Registry> var1);

    @Nonnull
    default public LifeCycle onStart(Throwing.Runnable task) {
        return this.onStart((Registry app) -> task.run());
    }

    @Nonnull
    default public LifeCycle onStarted(Throwing.Runnable task) {
        return this.onStarted((Registry app) -> task.run());
    }

    @Nonnull
    default public LifeCycle onStop(Throwing.Runnable task) {
        return this.onStop((Registry app) -> task.run());
    }

    @Nonnull
    public LifeCycle onStop(Throwing.Consumer<Registry> var1);
}

