/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import io.airlift.command.Command;

public class CommandFailedException
extends Exception {
    private final Integer exitCode;
    private final String output;
    private final Command command;

    public CommandFailedException(Command command, String message, Throwable cause) {
        super(CommandFailedException.exceptionMessage(command, message, cause), cause);
        this.command = command;
        this.exitCode = null;
        this.output = null;
    }

    public CommandFailedException(Command command, int exitCode, String output) {
        super(String.format("%s exited with %s%n%s", command.getCommand(), exitCode, output));
        this.command = command;
        this.exitCode = exitCode;
        this.output = output;
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean exited() {
        return this.exitCode != null;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output;
    }

    private static String exceptionMessage(Command command, String message, Throwable cause) {
        String s2 = cause == null ? "" : ": " + cause.getMessage();
        return String.format("%s %s%s", command.getCommand(), message, s2);
    }
}

