/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util.http;

public final class UTF8UrlEncoder {
    private static final boolean[] SAFE_ASCII;
    private static final char[] HEX;

    private UTF8UrlEncoder() {
    }

    public static String encode(CharSequence input) {
        return UTF8UrlEncoder.encode(input, false);
    }

    public static String encode(CharSequence input, boolean encodeSpaceUsingPlus) {
        StringBuilder sb = new StringBuilder(input.length() + 16);
        UTF8UrlEncoder.appendEncoded(sb, input, encodeSpaceUsingPlus);
        return sb.toString();
    }

    public static StringBuilder appendEncoded(StringBuilder sb, CharSequence input) {
        return UTF8UrlEncoder.appendEncoded(sb, input, false);
    }

    public static StringBuilder appendEncoded(StringBuilder sb, CharSequence input, boolean encodeSpaceUsingPlus) {
        int c;
        for (int i = 0; i < input.length(); i += Character.charCount(c)) {
            c = Character.codePointAt(input, i);
            if (c <= 127) {
                if (SAFE_ASCII[c]) {
                    sb.append((char)c);
                    continue;
                }
                UTF8UrlEncoder.appendSingleByteEncoded(sb, c, encodeSpaceUsingPlus);
                continue;
            }
            UTF8UrlEncoder.appendMultiByteEncoded(sb, c, encodeSpaceUsingPlus);
        }
        return sb;
    }

    private static void appendSingleByteEncoded(StringBuilder sb, int value, boolean encodeSpaceUsingPlus) {
        if (encodeSpaceUsingPlus && value == 32) {
            sb.append('+');
            return;
        }
        sb.append('%');
        sb.append(HEX[value >> 4]);
        sb.append(HEX[value & 0xF]);
    }

    private static void appendMultiByteEncoded(StringBuilder sb, int value, boolean encodeSpaceUsingPlus) {
        if (value < 2048) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xC0 | value >> 6, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, encodeSpaceUsingPlus);
        } else if (value < 65536) {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xE0 | value >> 12, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 6 & 0x3F, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, encodeSpaceUsingPlus);
        } else {
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0xF0 | value >> 18, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 12 & 0x3F, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value >> 6 & 0x3F, encodeSpaceUsingPlus);
            UTF8UrlEncoder.appendSingleByteEncoded(sb, 0x80 | value & 0x3F, encodeSpaceUsingPlus);
        }
    }

    static {
        int i;
        SAFE_ASCII = new boolean[128];
        for (i = 97; i <= 122; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            UTF8UrlEncoder.SAFE_ASCII[i] = true;
        }
        UTF8UrlEncoder.SAFE_ASCII[45] = true;
        UTF8UrlEncoder.SAFE_ASCII[46] = true;
        UTF8UrlEncoder.SAFE_ASCII[95] = true;
        UTF8UrlEncoder.SAFE_ASCII[126] = true;
        HEX = "0123456789ABCDEF".toCharArray();
    }
}

