/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.util.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Response;
import org.asynchttpclient.proxy.ProxyServer;
import org.killbill.billing.plugin.util.http.InvalidRequest;
import org.killbill.billing.plugin.util.http.ResponseFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_XML = "application/xml";
    protected static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected static final String GET = "GET";
    protected static final String POST = "POST";
    protected static final String PUT = "PUT";
    protected static final String DELETE = "DELETE";
    protected static final String HEAD = "HEAD";
    protected static final String OPTIONS = "OPTIONS";
    protected static final String USER_AGENT = "KillBill/1.0";
    protected static final ImmutableMap<String, String> DEFAULT_OPTIONS = ImmutableMap.of();
    protected static final int DEFAULT_HTTP_TIMEOUT_SEC = 70;
    private static final int DEFAULT_HTTP_CONNECT_TIMEOUT_SEC = 5;
    private static final int DEFAULT_HTTP_READ_TIMEOUT_SEC = 60;
    private static final int DEFAULT_HTTP_REQUEST_TIMEOUT_SEC = 60;
    protected final String username;
    protected final String password;
    protected final String url;
    protected final String proxyHost;
    protected final Integer proxyPort;
    protected final AsyncHttpClient httpClient;
    protected final ObjectMapper mapper;
    protected int httpTimeoutSec = 70;

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, Boolean strictSSL) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.httpClient = this.buildAsyncHttpClient(strictSSL, 60000, 60000, 5000);
        this.mapper = this.createObjectMapper();
    }

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, Boolean strictSSL, int connectTimeoutMs, int readTimeoutMs) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.httpClient = this.buildAsyncHttpClient(strictSSL, 60000, readTimeoutMs, connectTimeoutMs);
        this.mapper = this.createObjectMapper();
    }

    public HttpClient(String url, String username, String password, String proxyHost, Integer proxyPort, Boolean strictSSL, int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs) throws GeneralSecurityException {
        this.url = url;
        this.username = username;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.httpClient = this.buildAsyncHttpClient(strictSSL, requestTimeoutMs, readTimeoutMs, connectTimeoutMs);
        this.mapper = this.createObjectMapper();
        this.httpTimeoutSec = requestTimeoutMs / 1000 + 10;
    }

    private AsyncHttpClient buildAsyncHttpClient(Boolean strictSSL, int requestTimeoutMs, int readTimeoutMs, int connectTimeoutMs) throws GeneralSecurityException {
        DefaultAsyncHttpClientConfig.Builder cfg = new DefaultAsyncHttpClientConfig.Builder();
        cfg.setUserAgent(USER_AGENT).setConnectTimeout(connectTimeoutMs).setReadTimeout(readTimeoutMs).setRequestTimeout(requestTimeoutMs).setUseInsecureTrustManager(strictSSL == false);
        return new DefaultAsyncHttpClient(cfg.build());
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    protected ObjectMapper createObjectMapper() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    }

    @Deprecated
    protected <T> T doCall(String verb, String uri, String body, Map<String, String> options, Class<T> clazz) throws InterruptedException, ExecutionException, TimeoutException, IOException, URISyntaxException, InvalidRequest {
        String url = this.getUrl(this.url, uri);
        BoundRequestBuilder builder = this.getBuilderWithHeaderAndQuery(verb, url, options);
        if (!GET.equals(verb) && !HEAD.equals(verb) && body != null) {
            builder.setBody(body);
        }
        return this.executeAndWait(builder, this.httpTimeoutSec, clazz, ResponseFormat.JSON);
    }

    protected String doCallAndReturnTextResponse(String verb, String uri, String body, Map<String, String> queryParams, Map<String, String> headers) throws InvalidRequest, InterruptedException, ExecutionException, IOException, TimeoutException, URISyntaxException {
        return this.doCall(verb, uri, body, queryParams, headers, String.class, ResponseFormat.TEXT);
    }

    protected <T> T doCall(String verb, String uri, String body, Map<String, String> queryParams, Map<String, String> headers, Class<T> clazz, ResponseFormat format) throws InterruptedException, ExecutionException, TimeoutException, IOException, URISyntaxException, InvalidRequest {
        String url = this.getUrl(this.url, uri);
        BoundRequestBuilder builder = this.getBuilderWithHeaderAndQuery(verb, url, headers, queryParams);
        if (!GET.equals(verb) && !HEAD.equals(verb) && body != null) {
            builder.setBody(body);
        }
        return this.executeAndWait(builder, this.httpTimeoutSec, clazz, format);
    }

    protected <T> T executeAndWait(BoundRequestBuilder builder, int timeoutSec, Class<T> clazz, ResponseFormat format) throws IOException, InterruptedException, ExecutionException, TimeoutException, InvalidRequest {
        ListenableFuture<Response> futureStatus = builder.execute(new AsyncCompletionHandler<Response>(){

            @Override
            public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug(new String(content.getBodyPartBytes(), Charsets.UTF_8));
                }
                return super.onBodyPartReceived(content);
            }

            @Override
            public Response onCompleted(Response response) throws Exception {
                return response;
            }
        });
        Response response = (Response)futureStatus.get(timeoutSec, TimeUnit.SECONDS);
        if (response != null && response.getStatusCode() == 401) {
            throw new InvalidRequest("Unauthorized request", response);
        }
        if (response != null && response.getStatusCode() >= 400) {
            throw new InvalidRequest("Invalid request", response);
        }
        if (response == null) {
            throw new InvalidRequest("No response");
        }
        return this.deserializeResponse(response, clazz, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T deserializeResponse(Response response, Class<T> clazz, ResponseFormat format) throws IOException {
        try (InputStream in = null;){
            in = response.getResponseBodyAsStream();
            switch (format) {
                case TEXT: {
                    String string = CharStreams.toString(new InputStreamReader(in, Charsets.UTF_8));
                    return (T)string;
                }
            }
            T t2 = this.mapper.readValue(in, clazz);
            return t2;
        }
    }

    @Deprecated
    protected BoundRequestBuilder getBuilderWithHeaderAndQuery(String verb, String url, Map<String, String> immutableOptions) {
        BoundRequestBuilder builder = this.prepareBuilder(verb, url);
        HashMap<String, String> options = new HashMap<String, String>(immutableOptions);
        if (options.get("Accept") != null) {
            builder.addHeader((CharSequence)"Accept", (String)options.remove("Accept"));
        }
        if (options.get("Content-Type") != null) {
            builder.addHeader((CharSequence)"Content-Type", (String)options.remove("Content-Type"));
        }
        for (Map.Entry entry : options.entrySet()) {
            if (entry.getValue() == null) continue;
            builder.addQueryParam((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.proxyHost != null && this.proxyPort != null) {
            ProxyServer proxyServer = new ProxyServer.Builder(this.proxyHost, this.proxyPort).build();
            builder.setProxyServer(proxyServer);
        }
        return builder;
    }

    protected BoundRequestBuilder getBuilderWithHeaderAndQuery(String verb, String url, Map<String, String> headers, Map<String, String> queryParams) {
        BoundRequestBuilder builder = this.prepareBuilder(verb, url);
        this.addHeadsOrParams(headers, (key, value) -> {
            BoundRequestBuilder cfr_ignored_0 = (BoundRequestBuilder)builder.addHeader((CharSequence)key, (String)value);
        });
        this.addHeadsOrParams(queryParams, (key, value) -> {
            BoundRequestBuilder cfr_ignored_0 = (BoundRequestBuilder)builder.addQueryParam((String)key, (String)value);
        });
        return builder;
    }

    private void addHeadsOrParams(Map<String, String> options, BiConsumer<String, String> consumer) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    private BoundRequestBuilder prepareBuilder(String verb, String url) {
        BoundRequestBuilder builder;
        if (GET.equals(verb)) {
            builder = this.httpClient.prepareGet(url);
        } else if (POST.equals(verb)) {
            builder = this.httpClient.preparePost(url);
        } else if (PUT.equals(verb)) {
            builder = this.httpClient.preparePut(url);
        } else if (DELETE.equals(verb)) {
            builder = this.httpClient.prepareDelete(url);
        } else if (HEAD.equals(verb)) {
            builder = this.httpClient.prepareHead(url);
        } else if (OPTIONS.equals(verb)) {
            builder = this.httpClient.prepareOptions(url);
        } else {
            throw new IllegalArgumentException("Unrecognized verb: " + verb);
        }
        if (this.username != null || this.password != null) {
            Realm.Builder realm = new Realm.Builder(this.username, this.password);
            realm.setUsePreemptiveAuth(true);
            realm.setScheme(Realm.AuthScheme.BASIC);
            builder.setRealm(realm.build());
        }
        if (this.proxyHost != null && this.proxyPort != null) {
            ProxyServer proxyServer = new ProxyServer.Builder(this.proxyHost, this.proxyPort).build();
            builder.setProxyServer(proxyServer);
        }
        return builder;
    }

    private String getUrl(String location, String uri) throws URISyntaxException {
        if (uri == null) {
            throw new URISyntaxException("(null)", "HttpClient URL misconfigured");
        }
        URI u = new URI(uri);
        if (u.isAbsolute()) {
            return uri;
        }
        return String.format("%s%s", location, uri);
    }
}

