/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.jooq.SQLDialect;
import org.jooq.conf.MappedSchema;
import org.jooq.conf.RenderMapping;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginDao.class);
    public static final byte TRUE = 49;
    public static final byte FALSE = 48;
    protected static final String DEFAULT_SCHEMA_NAME = "killbill";
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    protected static final XmlMapper XML_MAPPER = new XmlMapper();
    protected final DataSource dataSource;
    protected final SQLDialect dialect;
    protected final Settings settings;

    public PluginDao(DataSource dataSource) throws SQLException {
        this(dataSource, PluginDao.getSQLDialect(PluginDao.getDBEngine(dataSource)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginDao(DataSource dataSource, SQLDialect dialect) throws SQLException {
        this.dataSource = dataSource;
        this.dialect = dialect;
        switch (dialect) {
            case H2: {
                String schema;
                try (Connection connection = null;){
                    connection = dataSource.getConnection();
                    schema = connection.getSchema();
                }
                MappedSchema mappedSchema = new MappedSchema().withInput(DEFAULT_SCHEMA_NAME).withOutput(schema);
                RenderMapping renderMapping = new RenderMapping().withSchemata(mappedSchema);
                this.settings = new Settings().withRenderMapping(renderMapping).withRenderNameCase(RenderNameCase.UPPER);
                break;
            }
            default: {
                this.settings = new Settings().withRenderSchema(false);
            }
        }
    }

    public PluginDao(DataSource dataSource, Settings settings) throws SQLException {
        this(dataSource, PluginDao.getSQLDialect(PluginDao.getDBEngine(dataSource)), settings);
    }

    public PluginDao(DataSource dataSource, SQLDialect dialect, Settings settings) {
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.settings = settings;
    }

    protected static byte fromBoolean(Boolean bool) {
        return bool != false ? (byte)49 : 48;
    }

    protected static LocalDateTime toLocalDateTime(@Nullable DateTime dateTime) {
        return dateTime == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(dateTime.getMillis()), ZoneId.of(dateTime.getZone().getID()));
    }

    protected static Timestamp toTimestamp(@Nullable DateTime dateTime) {
        return dateTime == null ? null : new Timestamp(dateTime.getMillis());
    }

    protected static Timestamp toTimestamp(@Nullable Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    protected String getProperty(String key, Map additionalData) {
        return Strings.emptyToNull(additionalData == null || additionalData.get(key) == null ? null : String.valueOf(additionalData.get(key)));
    }

    protected String asString(Map additionalData) throws SQLException {
        if (additionalData == null || additionalData.isEmpty()) {
            return null;
        }
        return this.asString((Object)additionalData);
    }

    protected String asString(Object additionalData) throws SQLException {
        try {
            return objectMapper.writeValueAsString(additionalData);
        }
        catch (JsonProcessingException e) {
            throw new SQLException(e);
        }
    }

    public static SQLDialect getSQLDialect(DBEngine dbEngine) {
        switch (dbEngine) {
            case H2: {
                return SQLDialect.H2;
            }
            case MYSQL: {
                return SQLDialect.MARIADB;
            }
            case POSTGRESQL: {
                return SQLDialect.POSTGRES;
            }
            case GENERIC: {
                logger.warn("Generic DBEngine detected, falling back to SQLDialect.MYSQL");
                return SQLDialect.MYSQL;
            }
        }
        throw new IllegalArgumentException("Unsupported DB engine: " + (Object)((Object)dbEngine));
    }

    public static DBEngine getDBEngine(DataSource dataSource) throws SQLException {
        String databaseProductName;
        try (Connection connection = null;){
            connection = dataSource.getConnection();
            databaseProductName = connection.getMetaData().getDatabaseProductName();
        }
        DBEngine dbEngine = "H2".equalsIgnoreCase(databaseProductName) ? DBEngine.H2 : ("MySQL".equalsIgnoreCase(databaseProductName) ? DBEngine.MYSQL : ("PostgreSQL".equalsIgnoreCase(databaseProductName) ? DBEngine.POSTGRESQL : DBEngine.GENERIC));
        return dbEngine;
    }

    public static Settings getSettings(InputStream xml) throws IOException {
        return XML_MAPPER.readValue(xml, Settings.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(Connection conn, WithConnectionCallback<T> callback) throws SQLException {
        try {
            T t2 = callback.withConnection(conn);
            return t2;
        }
        finally {
            conn.close();
        }
    }

    public static enum DBEngine {
        GENERIC,
        MYSQL,
        H2,
        POSTGRESQL;

    }

    protected static interface WithConnectionCallback<T> {
        public T withConnection(Connection var1) throws SQLException;
    }
}

