/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.payment;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.HostedPaymentPageFormDescriptor;
import org.killbill.billing.plugin.util.http.QueryComputer;
import org.killbill.billing.plugin.util.http.URIUtils;

public class PluginHostedPaymentPageFormDescriptor
implements HostedPaymentPageFormDescriptor {
    public static final String GET = "GET";
    public static final String POST = "POST";
    private final UUID kbAccountId;
    private final String formMethod;
    private final String formUrl;
    private final List<PluginProperty> formFields;
    private final List<PluginProperty> properties;

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl) {
        this(kbAccountId, GET, formUrl, ImmutableList.of());
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl, List<PluginProperty> formFields) {
        this(kbAccountId, POST, formUrl, formFields);
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, List<PluginProperty> formFields) {
        this(kbAccountId, formMethod, formUrl, formFields, ImmutableList.of());
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, List<PluginProperty> formFields, List<PluginProperty> properties) {
        this.kbAccountId = kbAccountId;
        this.formMethod = formMethod;
        this.formUrl = formUrl;
        this.formFields = formFields;
        this.properties = properties;
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formUrl, Map<String, String> queryParams) throws URISyntaxException {
        this(kbAccountId, GET, formUrl, queryParams);
    }

    public PluginHostedPaymentPageFormDescriptor(UUID kbAccountId, String formMethod, String formUrl, Map<String, String> queryParams) throws URISyntaxException {
        URI rawUrl = new URI(formUrl);
        String fullQueryString = QueryComputer.URL_ENCODING_ENABLED_QUERY_COMPUTER.computeFullQueryString(rawUrl.getQuery(), queryParams);
        String fullUrl = URIUtils.buildURI(rawUrl.getScheme(), rawUrl.getUserInfo(), rawUrl.getHost(), rawUrl.getPort(), rawUrl.getAuthority(), rawUrl.getPath(), fullQueryString, rawUrl.getFragment());
        this.kbAccountId = kbAccountId;
        this.formMethod = formMethod;
        this.formUrl = fullUrl;
        this.formFields = ImmutableList.of();
        this.properties = ImmutableList.of();
    }

    public UUID getKbAccountId() {
        return this.kbAccountId;
    }

    public String getFormMethod() {
        return this.formMethod;
    }

    public String getFormUrl() {
        return this.formUrl;
    }

    public List<PluginProperty> getFormFields() {
        return this.formFields;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginHostedPaymentPageFormDescriptor{");
        sb.append("kbAccountId=").append(this.kbAccountId);
        sb.append(", formMethod='").append(this.formMethod).append('\'');
        sb.append(", formUrl='").append(this.formUrl).append('\'');
        sb.append(", formFields=").append(this.formFields);
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginHostedPaymentPageFormDescriptor that = (PluginHostedPaymentPageFormDescriptor)o;
        if (this.formFields != null ? !this.formFields.equals(that.formFields) : that.formFields != null) {
            return false;
        }
        if (this.formMethod != null ? !this.formMethod.equals(that.formMethod) : that.formMethod != null) {
            return false;
        }
        if (this.formUrl != null ? !this.formUrl.equals(that.formUrl) : that.formUrl != null) {
            return false;
        }
        if (this.kbAccountId != null ? !this.kbAccountId.equals(that.kbAccountId) : that.kbAccountId != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.kbAccountId != null ? this.kbAccountId.hashCode() : 0;
        result = 31 * result + (this.formMethod != null ? this.formMethod.hashCode() : 0);
        result = 31 * result + (this.formUrl != null ? this.formUrl.hashCode() : 0);
        result = 31 * result + (this.formFields != null ? this.formFields.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

