/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.payment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.plugin.api.GatewayNotification;

public class PluginGatewayNotification
implements GatewayNotification {
    protected final UUID kbPaymentId;
    protected final int status;
    protected final String entity;
    protected final Map<String, List<String>> headers;
    protected final List<PluginProperty> properties;

    public PluginGatewayNotification(String entity) {
        this(null, 200, entity, ImmutableMap.of(), ImmutableList.of());
    }

    public PluginGatewayNotification(UUID kbPaymentId, int status, String entity, Map<String, List<String>> headers, List<PluginProperty> properties) {
        this.kbPaymentId = kbPaymentId;
        this.status = status;
        this.entity = entity;
        this.headers = headers;
        this.properties = properties;
    }

    public UUID getKbPaymentId() {
        return this.kbPaymentId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getEntity() {
        return this.entity;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginGatewayNotification{");
        sb.append("kbPaymentId=").append(this.kbPaymentId);
        sb.append(", status=").append(this.status);
        sb.append(", entity='").append(this.entity).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginGatewayNotification that = (PluginGatewayNotification)o;
        if (this.status != that.status) {
            return false;
        }
        if (this.entity != null ? !this.entity.equals(that.entity) : that.entity != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.kbPaymentId != null ? !this.kbPaymentId.equals(that.kbPaymentId) : that.kbPaymentId != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.kbPaymentId != null ? this.kbPaymentId.hashCode() : 0;
        result = 31 * result + this.status;
        result = 31 * result + (this.entity != null ? this.entity.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

