/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.notification;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.billing.plugin.api.PluginTenantContext;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.callcontext.TenantContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginConfigurationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigurationHandler.class);
    private final String configKeyName;
    private final OSGIKillbillAPI osgiKillbillAPI;

    public PluginConfigurationHandler(String pluginName, OSGIKillbillAPI osgiKillbillAPI) {
        this.configKeyName = "PLUGIN_CONFIG_" + pluginName;
        this.osgiKillbillAPI = osgiKillbillAPI;
    }

    protected abstract void configure(@Nullable UUID var1);

    protected void configure(String eventConfigKeyName, @Nullable UUID kbTenantId) {
        if (eventConfigKeyName.equals(this.configKeyName)) {
            this.configure(kbTenantId);
        }
    }

    protected Properties getTenantConfigurationAsProperties(@Nullable UUID kbTenantId) {
        String tenantConfigurationAsString = this.getTenantConfigurationAsString(kbTenantId);
        if (tenantConfigurationAsString == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(tenantConfigurationAsString));
            return properties;
        }
        catch (IOException e) {
            logger.warn("Exception while loading properties for key {}", (Object)this.configKeyName, (Object)e);
            return null;
        }
    }

    protected String getTenantConfigurationAsString(@Nullable UUID kbTenantId) {
        if (kbTenantId == null) {
            return null;
        }
        TenantUserApi tenantUserApi = this.osgiKillbillAPI.getTenantUserApi();
        if (tenantUserApi == null) {
            logger.warn("Unable to retrieve TenantUserApi - skipping reconfiguration for key {}", (Object)this.configKeyName);
            return null;
        }
        PluginTenantContext context = new PluginTenantContext(null, kbTenantId);
        try {
            List values = tenantUserApi.getTenantValuesForKey(this.configKeyName, (TenantContext)context);
            return !values.isEmpty() ? (String)values.get(0) : null;
        }
        catch (TenantApiException e) {
            logger.warn("Exception while retrieving configuration for key {}", (Object)this.configKeyName, (Object)e);
            return null;
        }
    }
}

