/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.invoice;

import java.math.BigDecimal;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;

public class PluginInvoiceItem
implements InvoiceItem {
    protected final UUID id;
    protected final InvoiceItemType invoiceItemType;
    protected final UUID invoiceId;
    protected final UUID accountId;
    protected final UUID childAccountId;
    protected final LocalDate startDate;
    protected final LocalDate endDate;
    protected final BigDecimal amount;
    protected final Currency currency;
    protected final String description;
    protected final UUID subscriptionId;
    protected final UUID bundleId;
    protected final DateTime catalogEffectiveDate;
    protected final String productName;
    protected final String prettyProductName;
    protected final String planName;
    protected final String prettyPlanName;
    protected final String phaseName;
    protected final String prettyPhaseName;
    protected final BigDecimal rate;
    protected final UUID linkedItemId;
    protected final String usageName;
    protected final String prettyUsageName;
    protected final Integer quantity;
    protected final String itemDetails;
    protected final DateTime createdDate;
    protected final DateTime updatedDate;

    public static PluginInvoiceItem createTaxItem(InvoiceItem model, UUID invoiceId, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, model.getStartDate(), model.getEndDate(), amount, description, InvoiceItemType.TAX);
    }

    public static PluginInvoiceItem createTaxItem(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, startDate, endDate, amount, description, InvoiceItemType.TAX);
    }

    public static PluginInvoiceItem createAdjustmentItem(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description) {
        return PluginInvoiceItem.create(model, invoiceId, startDate, endDate, amount, description, InvoiceItemType.ITEM_ADJ);
    }

    public static PluginInvoiceItem create(InvoiceItem model, UUID invoiceId, LocalDate startDate, LocalDate endDate, BigDecimal amount, String description, InvoiceItemType invoiceItemType) {
        return new PluginInvoiceItem(UUID.randomUUID(), invoiceItemType, invoiceId, model.getAccountId(), model.getChildAccountId(), startDate, endDate, amount, model.getCurrency(), description, model.getSubscriptionId(), model.getBundleId(), model.getCatalogEffectiveDate(), model.getProductName(), model.getPrettyProductName(), model.getPlanName(), model.getPrettyPlanName(), model.getPhaseName(), model.getPrettyPhaseName(), model.getRate(), model.getId(), model.getUsageName(), model.getPrettyUsageName(), model.getQuantity(), model.getItemDetails(), model.getCreatedDate(), model.getUpdatedDate());
    }

    public PluginInvoiceItem(UUID id, InvoiceItemType invoiceItemType, UUID invoiceId, UUID accountId, UUID childAccountId, LocalDate startDate, LocalDate endDate, BigDecimal amount, Currency currency, String description, UUID subscriptionId, UUID bundleId, DateTime catalogEffectiveDate, String productName, String prettyProductName, String planName, String prettyPlanName, String phaseName, String prettyPhaseName, BigDecimal rate, UUID linkedItemId, String usageName, String prettyUsageName, Integer quantity, String itemDetails, DateTime createdDate, DateTime updatedDate) {
        this.id = id;
        this.invoiceItemType = invoiceItemType;
        this.invoiceId = invoiceId;
        this.accountId = accountId;
        this.childAccountId = childAccountId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.amount = amount;
        this.currency = currency;
        this.description = description;
        this.subscriptionId = subscriptionId;
        this.bundleId = bundleId;
        this.catalogEffectiveDate = catalogEffectiveDate;
        this.productName = productName;
        this.prettyProductName = prettyProductName;
        this.planName = planName;
        this.prettyPlanName = prettyPlanName;
        this.phaseName = phaseName;
        this.prettyPhaseName = prettyPhaseName;
        this.rate = rate;
        this.linkedItemId = linkedItemId;
        this.usageName = usageName;
        this.prettyUsageName = prettyUsageName;
        this.quantity = quantity;
        this.itemDetails = itemDetails;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public UUID getId() {
        return this.id;
    }

    public InvoiceItemType getInvoiceItemType() {
        return this.invoiceItemType;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getChildAccountId() {
        return this.childAccountId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getPrettyProductName() {
        return this.prettyProductName;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public DateTime getCatalogEffectiveDate() {
        return this.catalogEffectiveDate;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getPrettyPlanName() {
        return this.prettyPlanName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getPrettyPhaseName() {
        return this.prettyPhaseName;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public UUID getLinkedItemId() {
        return this.linkedItemId;
    }

    public String getUsageName() {
        return this.usageName;
    }

    public String getPrettyUsageName() {
        return this.prettyUsageName;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getItemDetails() {
        return this.itemDetails;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean matches(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginInvoiceItem)) {
            return false;
        }
        PluginInvoiceItem that = (PluginInvoiceItem)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.childAccountId != null ? !this.childAccountId.equals(that.childAccountId) : that.childAccountId != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.invoiceItemType != that.invoiceItemType) {
            return false;
        }
        if (this.safeCompareTo(this.catalogEffectiveDate, that.catalogEffectiveDate) != 0) {
            return false;
        }
        if (this.safeCompareTo(this.startDate, that.startDate) != 0) {
            return false;
        }
        if (this.safeCompareTo(this.endDate, that.endDate) != 0) {
            return false;
        }
        if (this.safeCompareTo(this.amount, that.amount) != 0) {
            return false;
        }
        if (this.safeCompareTo(this.rate, that.rate) != 0) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.prettyPhaseName != null ? !this.prettyPhaseName.equals(that.prettyPhaseName) : that.prettyPhaseName != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.prettyPlanName != null ? !this.prettyPlanName.equals(that.prettyPlanName) : that.prettyPlanName != null) {
            return false;
        }
        if (this.usageName != null ? !this.usageName.equals(that.usageName) : that.usageName != null) {
            return false;
        }
        if (this.prettyUsageName != null ? !this.prettyUsageName.equals(that.prettyUsageName) : that.prettyUsageName != null) {
            return false;
        }
        if (this.quantity != null ? !this.quantity.equals(that.quantity) : that.quantity != null) {
            return false;
        }
        return !(this.itemDetails != null ? !this.itemDetails.equals(that.itemDetails) : that.itemDetails != null);
    }

    protected <T> int safeCompareTo(Comparable<T> c1, T c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PluginInvoiceItem{");
        sb.append("id=").append(this.id);
        sb.append(", invoiceItemType=").append(this.invoiceItemType);
        sb.append(", invoiceId=").append(this.invoiceId);
        sb.append(", accountId=").append(this.accountId);
        sb.append(", childAccountId=").append(this.childAccountId);
        sb.append(", startDate=").append(this.startDate);
        sb.append(", endDate=").append(this.endDate);
        sb.append(", amount=").append(this.amount);
        sb.append(", currency=").append(this.currency);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", bundleId=").append(this.bundleId);
        sb.append(", catalogEffectiveDate=").append(this.catalogEffectiveDate);
        sb.append(", productName='").append(this.productName).append('\'');
        sb.append(", prettyProductName='").append(this.prettyProductName).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", prettyPlanName='").append(this.prettyPlanName).append('\'');
        sb.append(", phaseName='").append(this.phaseName).append('\'');
        sb.append(", prettyPhaseName='").append(this.prettyPhaseName).append('\'');
        sb.append(", rate=").append(this.rate);
        sb.append(", linkedItemId=").append(this.linkedItemId);
        sb.append(", usageName='").append(this.usageName).append('\'');
        sb.append(", prettyUsageName='").append(this.prettyUsageName).append('\'');
        sb.append(", quantity=").append(this.quantity);
        sb.append(", itemDetails='").append(this.itemDetails).append('\'');
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!this.matches(o)) {
            return false;
        }
        PluginInvoiceItem that = (PluginInvoiceItem)o;
        if (this.createdDate != null ? !this.createdDate.equals(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.linkedItemId != null ? !this.linkedItemId.equals(that.linkedItemId) : that.linkedItemId != null) {
            return false;
        }
        return !(this.updatedDate != null ? !this.updatedDate.equals(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.invoiceItemType != null ? this.invoiceItemType.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.childAccountId != null ? this.childAccountId.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.catalogEffectiveDate != null ? this.catalogEffectiveDate.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.prettyProductName != null ? this.prettyProductName.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.prettyPlanName != null ? this.prettyPlanName.hashCode() : 0);
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.prettyPhaseName != null ? this.prettyPhaseName.hashCode() : 0);
        result = 31 * result + (this.rate != null ? this.rate.hashCode() : 0);
        result = 31 * result + (this.linkedItemId != null ? this.linkedItemId.hashCode() : 0);
        result = 31 * result + (this.usageName != null ? this.usageName.hashCode() : 0);
        result = 31 * result + (this.prettyUsageName != null ? this.prettyUsageName.hashCode() : 0);
        result = 31 * result + (this.quantity != null ? this.quantity.hashCode() : 0);
        result = 31 * result + (this.itemDetails != null ? this.itemDetails.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        return result;
    }
}

