/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.tag.Tag;

public class PluginTag
implements Tag {
    protected final UUID objectId;
    protected final ObjectType objectType;
    protected final UUID tagDefinitionId;
    protected final UUID id;
    protected final DateTime createdDate;
    protected final DateTime updatedDate;

    public PluginTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, DateTime date) {
        this(objectId, objectType, tagDefinitionId, null, date, date);
    }

    public PluginTag(UUID objectId, ObjectType objectType, UUID tagDefinitionId, UUID id, DateTime createdDate, DateTime updatedDate) {
        this.objectId = objectId;
        this.objectType = objectType;
        this.tagDefinitionId = tagDefinitionId;
        this.id = id;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public UUID getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginTag{");
        sb.append("objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", tagDefinitionId=").append(this.tagDefinitionId);
        sb.append(", id=").append(this.id);
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginTag pluginTag = (PluginTag)o;
        if (this.objectId != null ? !this.objectId.equals(pluginTag.objectId) : pluginTag.objectId != null) {
            return false;
        }
        if (this.objectType != pluginTag.objectType) {
            return false;
        }
        if (this.tagDefinitionId != null ? !this.tagDefinitionId.equals(pluginTag.tagDefinitionId) : pluginTag.tagDefinitionId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(pluginTag.id) : pluginTag.id != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo(pluginTag.createdDate) != 0 : pluginTag.createdDate != null) {
            return false;
        }
        return this.updatedDate != null ? this.updatedDate.compareTo(pluginTag.updatedDate) == 0 : pluginTag.updatedDate == null;
    }

    public int hashCode() {
        int result = this.objectId != null ? this.objectId.hashCode() : 0;
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.tagDefinitionId != null ? this.tagDefinitionId.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        return result;
    }
}

