/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.math.BigDecimal;
import java.util.List;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.UsagePriceOverride;

public class PluginPlanPhasePriceOverride
implements PlanPhasePriceOverride {
    private final String phaseName;
    private final PlanPhaseSpecifier planPhaseSpecifier;
    private final Currency currency;
    private final BigDecimal fixedPrice;
    private final BigDecimal recurringPrice;
    private final List<UsagePriceOverride> usagePriceOverrides;

    public PluginPlanPhasePriceOverride(String phaseName, BigDecimal recurringPrice, Currency currency) {
        this(phaseName, null, currency, null, recurringPrice, null);
    }

    public PluginPlanPhasePriceOverride(String phaseName, PlanPhaseSpecifier planPhaseSpecifier, Currency currency, BigDecimal fixedPrice, BigDecimal recurringPrice, List<UsagePriceOverride> usagePriceOverrides) {
        this.phaseName = phaseName;
        this.planPhaseSpecifier = planPhaseSpecifier;
        this.currency = currency;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
        this.usagePriceOverrides = usagePriceOverrides;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public PlanPhaseSpecifier getPlanPhaseSpecifier() {
        return this.planPhaseSpecifier;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public List<UsagePriceOverride> getUsagePriceOverrides() {
        return this.usagePriceOverrides;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginPlanPhasePriceOverride{");
        sb.append("phaseName='").append(this.phaseName).append('\'');
        sb.append(", planPhaseSpecifier=").append(this.planPhaseSpecifier);
        sb.append(", currency=").append(this.currency);
        sb.append(", fixedPrice=").append(this.fixedPrice);
        sb.append(", recurringPrice=").append(this.recurringPrice);
        sb.append(", usagePriceOverrides=").append(this.usagePriceOverrides);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginPlanPhasePriceOverride that = (PluginPlanPhasePriceOverride)o;
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.planPhaseSpecifier != null ? !this.planPhaseSpecifier.equals(that.planPhaseSpecifier) : that.planPhaseSpecifier != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.fixedPrice != null ? this.fixedPrice.compareTo(that.fixedPrice) != 0 : that.fixedPrice != null) {
            return false;
        }
        if (this.recurringPrice != null ? this.recurringPrice.compareTo(that.recurringPrice) != 0 : that.recurringPrice != null) {
            return false;
        }
        return this.usagePriceOverrides != null ? this.usagePriceOverrides.equals(that.usagePriceOverrides) : that.usagePriceOverrides == null;
    }

    public int hashCode() {
        int result = this.phaseName != null ? this.phaseName.hashCode() : 0;
        result = 31 * result + (this.planPhaseSpecifier != null ? this.planPhaseSpecifier.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        result = 31 * result + (this.usagePriceOverrides != null ? this.usagePriceOverrides.hashCode() : 0);
        return result;
    }
}

