/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.DryRunType;

public class PluginDryRunArguments
implements DryRunArguments {
    private final DryRunType dryRunType;
    private final EntitlementSpecifier entitlementSpecifier;
    private final SubscriptionEventType action;
    private final UUID subscriptionId;
    private final LocalDate effectiveDate;
    private final UUID bundleId;
    private final BillingActionPolicy billingActionPolicy;

    public PluginDryRunArguments(UUID bundleId, UUID subscriptionId) {
        this(DryRunType.UPCOMING_INVOICE, null, null, subscriptionId, null, bundleId, null);
    }

    public PluginDryRunArguments(DryRunType dryRunType, EntitlementSpecifier entitlementSpecifier, SubscriptionEventType action, UUID subscriptionId, LocalDate effectiveDate, UUID bundleId, BillingActionPolicy billingActionPolicy) {
        this.dryRunType = dryRunType;
        this.entitlementSpecifier = entitlementSpecifier;
        this.action = action;
        this.subscriptionId = subscriptionId;
        this.effectiveDate = effectiveDate;
        this.bundleId = bundleId;
        this.billingActionPolicy = billingActionPolicy;
    }

    public DryRunType getDryRunType() {
        return this.dryRunType;
    }

    public EntitlementSpecifier getEntitlementSpecifier() {
        return this.entitlementSpecifier;
    }

    public SubscriptionEventType getAction() {
        return this.action;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public BillingActionPolicy getBillingActionPolicy() {
        return this.billingActionPolicy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginDryRunArguments{");
        sb.append("dryRunType=").append(this.dryRunType);
        sb.append(", entitlementSpecifier=").append(this.entitlementSpecifier);
        sb.append(", action=").append(this.action);
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", bundleId=").append(this.bundleId);
        sb.append(", billingActionPolicy=").append(this.billingActionPolicy);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDryRunArguments that = (PluginDryRunArguments)o;
        if (this.dryRunType != that.dryRunType) {
            return false;
        }
        if (this.entitlementSpecifier != null ? !this.entitlementSpecifier.equals(that.entitlementSpecifier) : that.entitlementSpecifier != null) {
            return false;
        }
        if (this.action != that.action) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo(that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        return this.billingActionPolicy == that.billingActionPolicy;
    }

    public int hashCode() {
        int result = this.dryRunType != null ? this.dryRunType.hashCode() : 0;
        result = 31 * result + (this.entitlementSpecifier != null ? this.entitlementSpecifier.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.billingActionPolicy != null ? this.billingActionPolicy.hashCode() : 0);
        return result;
    }
}

