/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.ObjectType;
import org.killbill.billing.util.customfield.CustomField;

public class PluginCustomField
implements CustomField {
    protected final UUID objectId;
    protected final ObjectType objectType;
    protected final String fieldName;
    protected final String fieldValue;
    protected final UUID id;
    protected final DateTime createdDate;
    protected final DateTime updatedDate;

    public PluginCustomField(UUID objectId, ObjectType objectType, String fieldName, String fieldValue, DateTime date) {
        this(objectId, objectType, fieldName, fieldValue, null, date, date);
    }

    public PluginCustomField(UUID objectId, ObjectType objectType, String fieldName, String fieldValue, UUID id, DateTime createdDate, DateTime updatedDate) {
        this.objectId = objectId;
        this.objectType = objectType;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.id = id;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginCustomField{");
        sb.append("objectId=").append(this.objectId);
        sb.append(", objectType=").append(this.objectType);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", fieldValue='").append(this.fieldValue).append('\'');
        sb.append(", id=").append(this.id);
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginCustomField that = (PluginCustomField)o;
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        if (this.objectType != that.objectType) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.fieldValue != null ? !this.fieldValue.equals(that.fieldValue) : that.fieldValue != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo(that.createdDate) != 0 : that.createdDate != null) {
            return false;
        }
        return this.updatedDate != null ? this.updatedDate.compareTo(that.updatedDate) == 0 : that.updatedDate == null;
    }

    public int hashCode() {
        int result = this.objectId != null ? this.objectId.hashCode() : 0;
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + (this.fieldValue != null ? this.fieldValue.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        return result;
    }
}

