/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api.core;

import java.util.Locale;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.catalog.api.Currency;

public class PluginAccountData
implements AccountData {
    protected final String externalKey;
    protected final String email;
    protected final String name;
    protected final Integer firstNameLength;
    protected final Currency currency;
    protected final UUID parentAccountId;
    protected final Boolean isPaymentDelegatedToParent;
    protected final Integer billCycleDayLocal;
    protected final UUID paymentMethodId;
    protected final DateTime referenceTime;
    protected final DateTimeZone timeZone;
    protected final String locale;
    protected final String address1;
    protected final String address2;
    protected final String companyName;
    protected final String city;
    protected final String stateOrProvince;
    protected final String country;
    protected final String postalCode;
    protected final String phone;
    protected final String notes;
    protected final Boolean isMigrated;

    public PluginAccountData(String externalKey) {
        this(externalKey, Currency.USD, DateTimeZone.UTC, Locale.US.toString(), "US");
    }

    public PluginAccountData(String externalKey, Currency currency, DateTimeZone timeZone, String locale, String country) {
        this(externalKey, null, null, null, currency, null, null, null, null, null, timeZone, locale, null, null, null, null, null, country, null, null, null, null, null);
    }

    public PluginAccountData(String externalKey, String email, String name, Integer firstNameLength, Currency currency, UUID parentAccountId, Boolean isPaymentDelegatedToParent, Integer billCycleDayLocal, UUID paymentMethodId, DateTime referenceTime, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes, Boolean isMigrated, Boolean isNotifiedForInvoices) {
        this.externalKey = externalKey;
        this.email = email;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.currency = currency;
        this.parentAccountId = parentAccountId;
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
        this.billCycleDayLocal = billCycleDayLocal;
        this.paymentMethodId = paymentMethodId;
        this.referenceTime = referenceTime;
        this.timeZone = timeZone;
        this.locale = locale;
        this.address1 = address1;
        this.address2 = address2;
        this.companyName = companyName;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.postalCode = postalCode;
        this.country = country;
        this.phone = phone;
        this.notes = notes;
        this.isMigrated = isMigrated;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public Boolean isPaymentDelegatedToParent() {
        return this.isPaymentDelegatedToParent;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public DateTime getReferenceTime() {
        return this.referenceTime;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getAddress1() {
        return this.address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCity() {
        return this.city;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getNotes() {
        return this.notes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginAccountData{");
        sb.append("externalKey='").append(this.externalKey).append('\'');
        sb.append(", email='").append(this.email).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", firstNameLength=").append(this.firstNameLength);
        sb.append(", currency=").append(this.currency);
        sb.append(", parentAccountId=").append(this.parentAccountId);
        sb.append(", isPaymentDelegatedToParent=").append(this.isPaymentDelegatedToParent);
        sb.append(", billCycleDayLocal=").append(this.billCycleDayLocal);
        sb.append(", paymentMethodId=").append(this.paymentMethodId);
        sb.append(", timeZone=").append(this.timeZone);
        sb.append(", locale='").append(this.locale).append('\'');
        sb.append(", address1='").append(this.address1).append('\'');
        sb.append(", address2='").append(this.address2).append('\'');
        sb.append(", companyName='").append(this.companyName).append('\'');
        sb.append(", city='").append(this.city).append('\'');
        sb.append(", stateOrProvince='").append(this.stateOrProvince).append('\'');
        sb.append(", country='").append(this.country).append('\'');
        sb.append(", postalCode='").append(this.postalCode).append('\'');
        sb.append(", phone='").append(this.phone).append('\'');
        sb.append(", notes='").append(this.notes).append('\'');
        sb.append(", isMigrated=").append(this.isMigrated);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginAccountData that = (PluginAccountData)o;
        if (this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null) {
            return false;
        }
        if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
            return false;
        }
        if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.parentAccountId != null ? !this.parentAccountId.equals(that.parentAccountId) : that.parentAccountId != null) {
            return false;
        }
        if (this.isPaymentDelegatedToParent != null ? !this.isPaymentDelegatedToParent.equals(that.isPaymentDelegatedToParent) : that.isPaymentDelegatedToParent != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
            return false;
        }
        if (this.isMigrated != null ? !this.isMigrated.equals(that.isMigrated) : that.isMigrated != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.stateOrProvince != null ? !this.stateOrProvince.equals(that.stateOrProvince) : that.stateOrProvince != null) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) {
            return false;
        }
        return !(this.notes != null ? !this.notes.equals(that.notes) : that.notes != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.parentAccountId != null ? this.parentAccountId.hashCode() : 0);
        result = 31 * result + (this.isPaymentDelegatedToParent != null ? this.isPaymentDelegatedToParent.hashCode() : 0);
        result = 31 * result + this.billCycleDayLocal;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
        result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.stateOrProvince != null ? this.stateOrProvince.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.isMigrated != null ? this.isMigrated.hashCode() : 0);
        return result;
    }
}

