/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.plugin.api;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;

public class PluginCallContext
implements CallContext {
    protected final UUID userToken;
    protected final String userName;
    protected final CallOrigin callOrigin;
    protected final UserType userType;
    protected final String reasonCode;
    protected final String comments;
    protected final DateTime createdDate;
    protected final DateTime updatedDate;
    protected final UUID accountId;
    protected final UUID tenantId;

    public PluginCallContext(String pluginName, DateTime utcNow, UUID accountId, UUID tenantId) {
        this(UUID.randomUUID(), pluginName, CallOrigin.EXTERNAL, UserType.SYSTEM, null, null, utcNow, utcNow, accountId, tenantId);
    }

    public PluginCallContext(UUID userToken, String userName, CallOrigin callOrigin, UserType userType, String reasonCode, String comments, DateTime createdDate, DateTime updatedDate, UUID accountId, UUID tenantId) {
        this.userToken = userToken;
        this.userName = userName;
        this.callOrigin = callOrigin;
        this.userType = userType;
        this.reasonCode = reasonCode;
        this.comments = comments;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
        this.accountId = accountId;
        this.tenantId = tenantId;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public CallOrigin getCallOrigin() {
        return this.callOrigin;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getComments() {
        return this.comments;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PluginCallContext{");
        sb.append("userToken=").append(this.userToken);
        sb.append(", userName='").append(this.userName).append('\'');
        sb.append(", callOrigin=").append(this.callOrigin);
        sb.append(", userType=").append(this.userType);
        sb.append(", reasonCode='").append(this.reasonCode).append('\'');
        sb.append(", comments='").append(this.comments).append('\'');
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append(", accountId=").append(this.accountId);
        sb.append(", tenantId=").append(this.tenantId);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginCallContext that = (PluginCallContext)o;
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        if (this.callOrigin != that.callOrigin) {
            return false;
        }
        if (this.userType != that.userType) {
            return false;
        }
        if (this.reasonCode != null ? !this.reasonCode.equals(that.reasonCode) : that.reasonCode != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo(that.createdDate) != 0 : that.createdDate != null) {
            return false;
        }
        if (this.updatedDate != null ? this.updatedDate.compareTo(that.updatedDate) != 0 : that.updatedDate != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        return this.tenantId != null ? this.tenantId.equals(that.tenantId) : that.tenantId == null;
    }

    public int hashCode() {
        int result = this.userToken != null ? this.userToken.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.callOrigin != null ? this.callOrigin.hashCode() : 0);
        result = 31 * result + (this.userType != null ? this.userType.hashCode() : 0);
        result = 31 * result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        return result;
    }
}

