/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.Statement;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.F1;
import org.jooq.impl.Tools;

class QueryPartCollectionView<T extends QueryPart>
extends AbstractQueryPart
implements Collection<T> {
    private static final long serialVersionUID = -2936922742534009564L;
    final Collection<T> wrapped;
    int indentSize;
    Boolean qualify;
    String separator;
    F1<? super T, ? extends T> mapper;

    static final <T extends QueryPart> QueryPartCollectionView<T> wrap(Collection<T> wrapped) {
        return new QueryPartCollectionView<T>(wrapped);
    }

    QueryPartCollectionView(Collection<T> wrapped) {
        this.wrapped = wrapped;
        this.indentSize = 2;
        this.separator = ",";
    }

    QueryPartCollectionView<T> indentSize(int newIndentSize) {
        this.indentSize = newIndentSize <= 0 ? Integer.MAX_VALUE : newIndentSize;
        return this;
    }

    QueryPartCollectionView<T> qualify(boolean newQualify) {
        this.qualify = newQualify;
        return this;
    }

    QueryPartCollectionView<T> map(F1<? super T, ? extends T> newMapper) {
        this.mapper = newMapper;
        return this;
    }

    QueryPartCollectionView<T> separator(String newSeparator) {
        this.separator = newSeparator;
        return this;
    }

    Collection<T> wrapped() {
        return this.wrapped;
    }

    @Override
    public boolean rendersContent(Context<?> ctx) {
        return !this.isEmpty();
    }

    @Override
    public void accept(Context<?> ctx) {
        boolean indent;
        BitSet rendersContent = new BitSet(this.size());
        int i = 0;
        for (QueryPart e : this) {
            rendersContent.set(i++, ((QueryPartInternal)e).rendersContent(ctx));
        }
        int size = rendersContent.cardinality();
        boolean format = ctx.format() && size >= this.indentSize;
        boolean previousQualify = ctx.qualify();
        Object previousIndented = ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED);
        boolean bl = indent = format && !Boolean.TRUE.equals(previousIndented);
        if (this.qualify != null) {
            ctx.qualify(this.qualify);
        }
        if (indent) {
            ctx.formatIndentStart();
        }
        if (ctx.separatorRequired()) {
            if (format) {
                ctx.formatSeparator();
            } else {
                ctx.sql(' ');
            }
        }
        if (size == 0) {
            this.toSQLEmptyList(ctx);
        } else {
            int j = 0;
            int k = 0;
            for (QueryPart part : this) {
                if (!rendersContent.get(j++)) continue;
                if (this.mapper != null) {
                    part = (QueryPart)this.mapper.apply(part);
                }
                if (k++ > 0) {
                    if (!(part instanceof Statement)) {
                        ctx.sql(this.separator);
                    }
                    if (format) {
                        ctx.formatSeparator();
                    } else {
                        ctx.sql(' ');
                    }
                } else if (indent) {
                    ctx.formatNewLine();
                }
                if (indent) {
                    ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, part instanceof QueryPartCollectionView && ((QueryPartCollectionView)part).size() > 1);
                    ctx.visit(part);
                    ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, previousIndented);
                    continue;
                }
                ctx.visit(part);
            }
        }
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
        if (this.qualify != null) {
            ctx.qualify(previousQualify);
        }
    }

    protected void toSQLEmptyList(Context<?> context) {
    }

    @Override
    public final int size() {
        return this.wrapped.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public final boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public final <E> E[] toArray(E[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public final boolean add(T e) {
        if (e != null) {
            return this.wrapped.add(e);
        }
        return false;
    }

    @Override
    public final boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    final void addAll(Iterable<? extends T> c) {
        if (c != null) {
            for (QueryPart t2 : c) {
                if (t2 == null) continue;
                this.add((T)t2);
            }
        }
    }

    @Override
    public final boolean addAll(Collection<? extends T> c) {
        return this.wrapped.addAll(this.removeNulls(c));
    }

    final Collection<? extends T> removeNulls(Collection<? extends T> c) {
        boolean containsNulls;
        try {
            containsNulls = c.contains(null);
        }
        catch (NullPointerException ignore) {
            containsNulls = false;
        }
        if (containsNulls) {
            ArrayList<T> list = new ArrayList<T>(c);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                it.remove();
            }
            return list;
        }
        return c;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public final void clear() {
        this.wrapped.clear();
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QueryPartCollectionView && this.getClass() == that.getClass()) {
            return this.wrapped.equals(((QueryPartCollectionView)that).wrapped);
        }
        return super.equals(that);
    }
}

