/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.JoinType;
import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TableOptions;
import org.jooq.TableOuterJoinStep;
import org.jooq.TablePartitionByStep;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;

final class JoinTable
extends AbstractTable<Record>
implements TableOuterJoinStep<Record>,
TableOptionalOnStep<Record>,
TablePartitionByStep<Record>,
TableOnConditionStep<Record> {
    private static final long serialVersionUID = 8377996833996498178L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE, Clause.TABLE_JOIN};
    private static final Set<SQLDialect> EMULATE_NATURAL_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID);
    private static final Set<SQLDialect> EMULATE_NATURAL_OUTER_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.H2);
    private static final Set<SQLDialect> EMULATE_APPLY = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    final Table<?> lhs;
    final Table<?> rhs;
    final JoinType type;
    final ConditionProviderImpl condition;
    final QueryPartList<Field<?>> using;

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type) {
        super(TableOptions.expression(), Names.N_JOIN);
        this.lhs = lhs.asTable();
        this.rhs = rhs.asTable();
        this.type = type;
        this.condition = new ConditionProviderImpl();
        this.using = new QueryPartList();
    }

    JoinTable transform(Table<?> newLhs, Table<?> newRhs) {
        if (this.lhs == newLhs && this.rhs == newRhs) {
            return this;
        }
        JoinTable result = new JoinTable(newLhs, newRhs, this.type);
        return !this.using.isEmpty() ? result.using(this.using) : result.on((Condition)this.condition);
    }

    @Override
    public final List<ForeignKey<Record, ?>> getReferences() {
        List<ForeignKey<?, ?>> lhsReferences = this.lhs.getReferences();
        List<ForeignKey<?, ?>> rhsReferences = this.rhs.getReferences();
        ArrayList result = new ArrayList(lhsReferences.size() + rhsReferences.size());
        result.addAll(lhsReferences);
        result.addAll(rhsReferences);
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        JoinType translatedType = this.translateType(ctx);
        Clause translatedClause = this.translateClause(translatedType);
        Keyword keyword = this.translateKeyword(ctx, translatedType);
        this.toSQLTable(ctx, this.lhs);
        switch (translatedType) {
            case LEFT_SEMI_JOIN: 
            case LEFT_ANTI_JOIN: {
                if (!Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN))) break;
                ArrayList<Condition> semiAntiJoinPredicates = (ArrayList<Condition>)ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN);
                if (semiAntiJoinPredicates == null) {
                    semiAntiJoinPredicates = new ArrayList<Condition>();
                    ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, semiAntiJoinPredicates);
                }
                Condition c = !this.using.isEmpty() ? this.usingCondition() : this.condition;
                switch (translatedType) {
                    case LEFT_SEMI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.exists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                        break;
                    }
                    case LEFT_ANTI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.notExists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                    }
                }
                return;
            }
        }
        ctx.formatIndentStart().formatSeparator().start(translatedClause).visit(keyword).sql(' ');
        this.toSQLTable(ctx, this.rhs);
        if (!Arrays.asList(JoinType.CROSS_JOIN, JoinType.NATURAL_JOIN, JoinType.NATURAL_LEFT_OUTER_JOIN, JoinType.NATURAL_RIGHT_OUTER_JOIN, JoinType.NATURAL_FULL_OUTER_JOIN, JoinType.CROSS_APPLY, JoinType.OUTER_APPLY).contains((Object)translatedType)) {
            ctx.formatIndentStart();
            this.toSQLJoinCondition(ctx);
            ctx.formatIndentEnd();
        } else if (JoinType.OUTER_APPLY == translatedType && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            ctx.formatIndentStart().formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(" 1 = 1").end(Clause.TABLE_JOIN_ON).formatIndentEnd();
        }
        ctx.end(translatedClause).formatIndentEnd();
    }

    private final Keyword translateKeyword(Context<?> ctx, JoinType translatedType) {
        Keyword keyword;
        switch (translatedType) {
            case JOIN: 
            case NATURAL_JOIN: {
                if (ctx.settings().getRenderOptionalInnerKeyword() == RenderOptionalKeyword.ON) {
                    keyword = translatedType.toKeyword(true);
                    break;
                }
                keyword = translatedType.toKeyword();
                break;
            }
            case LEFT_OUTER_JOIN: 
            case NATURAL_LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case NATURAL_RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case NATURAL_FULL_OUTER_JOIN: {
                if (ctx.settings().getRenderOptionalOuterKeyword() == RenderOptionalKeyword.OFF) {
                    keyword = translatedType.toKeyword(false);
                    break;
                }
                keyword = translatedType.toKeyword();
                break;
            }
            default: {
                keyword = translatedType.toKeyword();
            }
        }
        if (translatedType == JoinType.CROSS_APPLY && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            keyword = Keywords.K_CROSS_JOIN_LATERAL;
        } else if (translatedType == JoinType.OUTER_APPLY && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            keyword = ctx.settings().getRenderOptionalOuterKeyword() == RenderOptionalKeyword.OFF ? Keywords.K_LEFT_JOIN_LATERAL : Keywords.K_LEFT_OUTER_JOIN_LATERAL;
        }
        return keyword;
    }

    private void toSQLTable(Context<?> ctx, Table<?> table) {
        boolean wrap;
        boolean bl = wrap = table instanceof JoinTable && table == this.rhs;
        if (wrap) {
            ctx.sql('(').formatIndentStart().formatNewLine();
        }
        ctx.visit(table);
        if (wrap) {
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
    }

    final Clause translateClause(JoinType translatedType) {
        switch (translatedType) {
            case JOIN: {
                return Clause.TABLE_JOIN_INNER;
            }
            case CROSS_JOIN: {
                return Clause.TABLE_JOIN_CROSS;
            }
            case NATURAL_JOIN: {
                return Clause.TABLE_JOIN_NATURAL;
            }
            case LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_LEFT;
            }
            case RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_RIGHT;
            }
            case FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_FULL;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_LEFT;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_RIGHT;
            }
            case NATURAL_FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_FULL;
            }
            case CROSS_APPLY: {
                return Clause.TABLE_JOIN_CROSS_APPLY;
            }
            case OUTER_APPLY: {
                return Clause.TABLE_JOIN_OUTER_APPLY;
            }
            case LEFT_SEMI_JOIN: {
                return Clause.TABLE_JOIN_SEMI_LEFT;
            }
            case LEFT_ANTI_JOIN: {
                return Clause.TABLE_JOIN_ANTI_LEFT;
            }
            case STRAIGHT_JOIN: {
                return Clause.TABLE_JOIN_STRAIGHT;
            }
        }
        throw new IllegalArgumentException("Bad join type: " + (Object)((Object)translatedType));
    }

    final JoinType translateType(Context<?> ctx) {
        if (this.emulateCrossJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalLeftOuterJoin(ctx)) {
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (this.emulateNaturalRightOuterJoin(ctx)) {
            return JoinType.RIGHT_OUTER_JOIN;
        }
        if (this.emulateNaturalFullOuterJoin(ctx)) {
            return JoinType.FULL_OUTER_JOIN;
        }
        return this.type;
    }

    private final boolean emulateCrossJoin(Context<?> ctx) {
        return false;
    }

    private final boolean emulateNaturalJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_JOIN && EMULATE_NATURAL_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalLeftOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalRightOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalFullOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_FULL_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final void toSQLJoinCondition(Context<?> ctx) {
        if (!this.using.isEmpty()) {
            boolean qualify = ctx.qualify();
            ctx.formatSeparator().start(Clause.TABLE_JOIN_USING).visit(Keywords.K_USING).sql(" (").qualify(false).visit(QueryPartListView.wrap(this.using).indentSize(0)).qualify(qualify).sql(')').end(Clause.TABLE_JOIN_USING);
        } else if (this.emulateNaturalJoin(ctx) || this.emulateNaturalLeftOuterJoin(ctx) || this.emulateNaturalRightOuterJoin(ctx) || this.emulateNaturalFullOuterJoin(ctx)) {
            this.toSQLJoinCondition(ctx, this.naturalCondition());
        } else {
            this.toSQLJoinCondition(ctx, this.condition);
        }
    }

    final Condition naturalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>(this.using.size());
        for (Field<?> field : this.lhs.fields()) {
            Field<?> other = this.rhs.field(field);
            if (other == null) continue;
            conditions.add(field.eq(other));
        }
        return DSL.and(conditions);
    }

    final Condition usingCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>(this.using.size());
        for (Field field : this.using) {
            conditions.add(Tools.qualify(this.lhs, field).eq(Tools.qualify(this.rhs, field)));
        }
        return DSL.and(conditions);
    }

    private final void toSQLJoinCondition(Context<?> context, Condition c) {
        context.formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(' ').visit(c).end(Clause.TABLE_JOIN_ON);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<Record> as(Name alias) {
        return new TableAlias<Record>(this, alias, true);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, true);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return this.lhs.getRecordType();
        }
        return RecordImplN.class;
    }

    @Override
    final Fields<Record> fields0() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return new Fields<Record>(this.lhs.asTable().fields());
        }
        Field<?>[] l = this.lhs.asTable().fields();
        Field<?>[] r = this.rhs.asTable().fields();
        Field[] all = new Field[l.length + r.length];
        System.arraycopy(l, 0, all, 0, l.length);
        System.arraycopy(r, 0, all, l.length, r.length);
        return new Fields<Record>(all);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    public final JoinTable on(Condition conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Condition ... conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Field<Boolean> c) {
        return this.on(DSL.condition(c));
    }

    public final JoinTable on(Boolean c) {
        return this.on(DSL.condition(c));
    }

    public final JoinTable on(SQL sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql, Object ... bindings) {
        this.and(sql, bindings);
        return this;
    }

    public final JoinTable on(String sql, QueryPart ... parts) {
        this.and(sql, parts);
        return this;
    }

    public final JoinTable onKey() throws DataAccessException {
        List<ForeignKey<?, ?>> leftToRight = this.lhs.getReferencesTo(this.rhs);
        List<ForeignKey<?, ?>> rightToLeft = this.rhs.getReferencesTo(this.lhs);
        if (leftToRight.size() == 1 && rightToLeft.size() == 0) {
            return this.onKey(leftToRight.get(0), this.lhs, this.rhs);
        }
        if (rightToLeft.size() == 1 && leftToRight.size() == 0) {
            return this.onKey(rightToLeft.get(0), this.rhs, this.lhs);
        }
        if (rightToLeft.isEmpty() && leftToRight.isEmpty()) {
            throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, leftToRight, rightToLeft);
        }
        throw this.onKeyException(OnKeyExceptionReason.AMBIGUOUS, null, null);
    }

    public final JoinTable onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        block5: {
            ArrayList unaliased;
            block6: {
                if (keyFields == null || keyFields.length <= 0) break block5;
                unaliased = new ArrayList(Arrays.asList(keyFields));
                for (int i = 0; i < unaliased.size(); ++i) {
                    TableField f = (TableField)unaliased.get(i);
                    Alias alias = Tools.alias(f.getTable());
                    if (alias == null) continue;
                    unaliased.set(i, (TableField)alias.wrapped().field(f));
                }
                if (this.search(this.lhs, keyFields[0].getTable()) == null) break block6;
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                    return this.onKey((ForeignKey)key);
                }
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased)) continue;
                    return this.onKey((ForeignKey)key);
                }
                break block5;
            }
            if (this.search(this.rhs, keyFields[0].getTable()) == null) break block5;
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                return this.onKey((ForeignKey)key);
            }
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(unaliased)) continue;
                return this.onKey((ForeignKey)key);
            }
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    public final JoinTable onKey(ForeignKey<?, ?> key) {
        if (this.search(this.lhs, key.getTable()) != null) {
            return this.onKey(key, this.lhs, this.rhs);
        }
        if (this.search(this.rhs, key.getTable()) != null) {
            return this.onKey(key, this.rhs, this.lhs);
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    private final Table<?> search(Table<?> tree, Table<?> search) {
        Alias<Table<?>> treeAlias = Tools.alias(tree);
        Alias<Table<?>> searchAlias = Tools.alias(search);
        if (treeAlias != null || searchAlias != null) {
            return this.search(treeAlias != null ? treeAlias.wrapped() : tree, searchAlias != null ? searchAlias.wrapped() : search);
        }
        if (tree instanceof JoinTable) {
            JoinTable t2 = (JoinTable)tree;
            Table<?> r = this.search(t2.lhs, search);
            if (r == null) {
                r = this.search(t2.rhs, search);
            }
            return r;
        }
        return search.equals(tree) ? tree : null;
    }

    private final JoinTable onKey(ForeignKey<?, ?> key, Table<?> fk, Table<?> pk) {
        JoinTable result = this;
        TableField<R, ?>[] references = key.getFieldsArray();
        TableField<?, ?>[] referenced = key.getKeyFieldsArray();
        for (int i = 0; i < references.length; ++i) {
            Field f1 = fk.field(references[i]);
            Field f2 = pk.field(referenced[i]);
            result.and(f1.equal(f2));
        }
        return result;
    }

    private final DataAccessException onKeyException(OnKeyExceptionReason reason, List<?> leftToRight, List<?> rightToLeft) {
        switch (reason) {
            case AMBIGUOUS: {
                return new DataAccessException("Key ambiguous between tables [" + this.lhs + "] and [" + this.rhs + "]. Found: " + leftToRight + " and " + rightToLeft);
            }
        }
        return new DataAccessException("No matching Key found between tables [" + this.lhs + "] and [" + this.rhs + "]");
    }

    public final JoinTable using(Field<?> ... fields) {
        return this.using(Arrays.asList(fields));
    }

    public final JoinTable using(Collection<? extends Field<?>> fields) {
        this.using.addAll((Collection<Field<?>>)fields);
        return this;
    }

    public final JoinTable and(Condition c) {
        this.condition.addConditions(c);
        return this;
    }

    public final JoinTable and(Field<Boolean> c) {
        return this.and(DSL.condition(c));
    }

    public final JoinTable and(Boolean c) {
        return this.and(DSL.condition(c));
    }

    public final JoinTable and(SQL sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql, Object ... bindings) {
        return this.and(DSL.condition(sql, bindings));
    }

    public final JoinTable and(String sql, QueryPart ... parts) {
        return this.and(DSL.condition(sql, parts));
    }

    public final JoinTable andNot(Condition c) {
        return this.and(c.not());
    }

    public final JoinTable andNot(Field<Boolean> c) {
        return this.andNot(DSL.condition(c));
    }

    public final JoinTable andNot(Boolean c) {
        return this.andNot(DSL.condition(c));
    }

    public final JoinTable andExists(Select<?> select) {
        return this.and(DSL.exists(select));
    }

    public final JoinTable andNotExists(Select<?> select) {
        return this.and(DSL.notExists(select));
    }

    public final JoinTable or(Condition c) {
        this.condition.addConditions(Operator.OR, c);
        return this;
    }

    public final JoinTable or(Field<Boolean> c) {
        return this.or(DSL.condition(c));
    }

    public final JoinTable or(Boolean c) {
        return this.or(DSL.condition(c));
    }

    public final JoinTable or(SQL sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql, Object ... bindings) {
        return this.or(DSL.condition(sql, bindings));
    }

    public final JoinTable or(String sql, QueryPart ... parts) {
        return this.or(DSL.condition(sql, parts));
    }

    public final JoinTable orNot(Condition c) {
        return this.or(c.not());
    }

    public final JoinTable orNot(Field<Boolean> c) {
        return this.orNot(DSL.condition(c));
    }

    public final JoinTable orNot(Boolean c) {
        return this.orNot(DSL.condition(c));
    }

    public final JoinTable orExists(Select<?> select) {
        return this.or(DSL.exists(select));
    }

    public final JoinTable orNotExists(Select<?> select) {
        return this.or(DSL.notExists(select));
    }

    private static enum OnKeyExceptionReason {
        AMBIGUOUS,
        NOT_FOUND;

    }
}

