/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;
import org.jooq.tools.json.ContainerFactory;
import org.jooq.tools.json.JSONParser;

final class JSONReader {
    private final DSLContext ctx;

    JSONReader(DSLContext ctx) {
        this.ctx = ctx;
    }

    final Result<Record> read(String string) {
        return this.read(new StringReader(string));
    }

    final Result<Record> read(Reader reader) {
        try {
            List records;
            Object root = new JSONParser().parse(reader, new ContainerFactory(){

                @Override
                public Map createObjectContainer() {
                    return new LinkedHashMap();
                }

                @Override
                public List createArrayContainer() {
                    return new ArrayList();
                }
            });
            ArrayList f = new ArrayList();
            Result<Record> result = null;
            HashMap<String, Integer> fieldIndexes = null;
            if (root instanceof Map) {
                Map o1 = (Map)root;
                List fields = (List)o1.get("fields");
                if (fields != null) {
                    for (Map field : fields) {
                        String catalog = (String)field.get("catalog");
                        String schema = (String)field.get("schema");
                        String table = (String)field.get("table");
                        String name = (String)field.get("name");
                        String type = (String)field.get("type");
                        f.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(this.ctx.dialect(), StringUtils.defaultIfBlank(type, "VARCHAR"))));
                    }
                    result = this.ctx.newResult(f);
                }
                records = (List)o1.get("records");
            } else {
                records = (List)root;
            }
            for (Object o3 : records) {
                Object record;
                if (o3 instanceof Map) {
                    record = (Map)o3;
                    String[] values = new String[record.size()];
                    if (result == null) {
                        if (f.isEmpty()) {
                            for (Object name : record.keySet()) {
                                f.add(DSL.field(DSL.name((String)name), SQLDataType.VARCHAR));
                            }
                        }
                        result = this.ctx.newResult(f);
                    }
                    if (fieldIndexes == null) {
                        Object name;
                        fieldIndexes = new HashMap<String, Integer>();
                        int i = 0;
                        name = record.keySet().iterator();
                        while (name.hasNext()) {
                            String name2 = (String)name.next();
                            fieldIndexes.put(name2, i++);
                        }
                    }
                    for (Map.Entry entry : record.entrySet()) {
                        values[((Integer)fieldIndexes.get(entry.getKey())).intValue()] = "" + entry.getValue();
                    }
                    Record r = this.ctx.newRecord(f);
                    r.from(values);
                    result.add(r);
                    continue;
                }
                record = (List)o3;
                if (result == null) {
                    if (f.isEmpty()) {
                        f.addAll(Arrays.asList(Tools.fields(record.size())));
                    }
                    result = this.ctx.newResult(f);
                }
                Record r = this.ctx.newRecord(f);
                for (int i = 0; i < f.size(); ++i) {
                    if (((Field)f.get(i)).getType() != byte[].class || !(record.get(i) instanceof String)) continue;
                    record.set(i, DatatypeConverter.parseBase64Binary((String)record.get(i)));
                }
                r.from(record);
                result.add(r);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

