/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.CommonTableExpressionImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.Values;

final class Alias<Q extends QueryPart>
extends AbstractQueryPart {
    private static final long serialVersionUID = -2456848365524191614L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    private static final Set<SQLDialect> SUPPORT_AS_REQUIRED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1 = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MYSQL);
    private static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2 = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL3 = SQLDialect.supportedBy(SQLDialect.H2);
    final Q wrapped;
    final Q wrapping;
    final Name alias;
    final Name[] fieldAliases;
    final boolean wrapInParentheses;

    Alias(Q wrapped, Q wrapping, Name alias) {
        this(wrapped, wrapping, alias, null, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, boolean wrapInParentheses) {
        this(wrapped, wrapping, alias, null, wrapInParentheses);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases) {
        this(wrapped, wrapping, alias, fieldAliases, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases, boolean wrapInParentheses) {
        this.wrapped = wrapped;
        this.wrapping = wrapping;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    @Override
    public final void accept(Context<?> context) {
        boolean qualify = context.qualify();
        if (context.declareAliases() && (context.declareFields() || context.declareTables())) {
            context.declareAliases(false);
            if (this.wrapped instanceof TableImpl) {
                context.scopeMarkStart((QueryPart)this.wrapping);
            }
            SQLDialect dialect = context.dialect();
            SQLDialect family = context.family();
            boolean emulatedDerivedColumnList = false;
            if (this.fieldAliases != null && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1.contains((Object)dialect) && (this.wrapped instanceof TableImpl || this.wrapped instanceof CommonTableExpressionImpl)) {
                Tools.visitSubquery(context, DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias)), true);
            } else if (this.fieldAliases != null && (SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2.contains((Object)dialect) || SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL3.contains((Object)dialect))) {
                emulatedDerivedColumnList = true;
                if (this.wrapped instanceof Values && Values.NO_SUPPORT_VALUES.contains((Object)dialect)) {
                    Object previous = context.data((Object)Tools.DataKey.DATA_SELECT_ALIASES, this.fieldAliases);
                    this.toSQLWrapped(context);
                    context.data((Object)Tools.DataKey.DATA_SELECT_ALIASES, previous);
                } else {
                    List<Name> names;
                    Select wrappedAsSelect = this.wrapped instanceof Select ? (Select)this.wrapped : (this.wrapped instanceof DerivedTable ? ((DerivedTable)this.wrapped).query() : DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias)));
                    List<Field<?>> select = wrappedAsSelect.getSelect();
                    if (SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL3.contains((Object)dialect) && (names = Tools.fieldNames(select)).size() > 0 && names.size() == new HashSet<Name>(names).size()) {
                        this.toSQLWrapped(context);
                        emulatedDerivedColumnList = false;
                    }
                    if (emulatedDerivedColumnList) {
                        SelectFieldList fields = new SelectFieldList();
                        for (int i = 0; i < this.fieldAliases.length; ++i) {
                            switch (family) {
                                default: 
                            }
                            fields.add(DSL.field("null").as(this.fieldAliases[i]));
                        }
                        Tools.visitSubquery(context, DSL.select(fields).where((Condition)DSL.falseCondition()).unionAll(wrappedAsSelect), true);
                    }
                }
            } else {
                this.toSQLWrapped(context);
            }
            this.toSQLAs(context);
            context.sql(' ').qualify(false).visit(this.alias).qualify(qualify);
            if (this.fieldAliases != null && !emulatedDerivedColumnList) {
                this.toSQLDerivedColumnList(context);
            } else {
                switch (family) {
                    case HSQLDB: 
                    case POSTGRES: {
                        Q o = this.wrapped;
                        if (!context.declareTables() || !(o instanceof ArrayTable)) break;
                        context.sql('(').visit(((QueryPartListView)QueryPartListView.wrap((QueryPart[])((ArrayTable)o).fields()).qualify(false)).indentSize(0)).sql(')');
                        break;
                    }
                }
            }
            if (this.wrapped instanceof TableImpl) {
                context.scopeMarkEnd((QueryPart)this.wrapping);
            }
            context.declareAliases(true);
        } else {
            context.qualify(false).visit(this.alias).qualify(qualify);
        }
    }

    final void toSQLAs(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_AS_REQUIRED))) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (this.wrapped instanceof Field) {
            if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
                ctx.sql(' ').visit(Keywords.K_AS);
            } else if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.ON) {
                ctx.sql(' ').visit(Keywords.K_AS);
            }
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.ON) {
            ctx.sql(' ').visit(Keywords.K_AS);
        }
    }

    private final void toSQLWrapped(Context<?> ctx) {
        ctx.sql(this.wrapInParentheses ? "(" : "").visit((QueryPart)this.wrapped).sql(this.wrapInParentheses ? ")" : "");
    }

    private final void toSQLDerivedColumnList(Context<?> ctx) {
        ctx.sql(" (").visit(QueryPartListView.wrap((QueryPart[])this.fieldAliases).indentSize(0)).sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }
}

