/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.typesafe.config.Config;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.MediaType;
import org.jooby.Parser;
import org.jooby.Renderer;
import org.jooby.json.JacksonParser;
import org.jooby.json.JacksonRawRenderer;
import org.jooby.json.JacksonRenderer;

public class Jackson
implements Jooby.Module {
    private final Optional<ObjectMapper> mapper;
    private MediaType type = MediaType.json;
    private Consumer<ObjectMapper> configurer;
    private List<Consumer<Multibinder<Module>>> modules = new ArrayList<Consumer<Multibinder<Module>>>();
    private boolean raw;

    public Jackson(ObjectMapper mapper) {
        this.mapper = Optional.of(Objects.requireNonNull(mapper, "The mapper is required."));
    }

    public Jackson() {
        this.mapper = Optional.empty();
    }

    public Jackson type(MediaType type) {
        this.type = type;
        return this;
    }

    public Jackson type(String type) {
        return this.type(MediaType.valueOf(type));
    }

    public Jackson doWith(Consumer<ObjectMapper> configurer) {
        this.configurer = Objects.requireNonNull(configurer, "ObjectMapper configurer is required.");
        return this;
    }

    public Jackson module(Module module) {
        Objects.requireNonNull(module, "Jackson Module is required.");
        this.modules.add(binder -> binder.addBinding().toInstance(module));
        return this;
    }

    public Jackson module(Class<? extends Module> module) {
        Objects.requireNonNull(module, "Jackson Module is required.");
        this.modules.add(binder -> binder.addBinding().to(module));
        return this;
    }

    public Jackson raw() {
        this.raw = true;
        return this;
    }

    @Override
    public void configure(Env env, Config config, Binder binder) {
        ObjectMapper mapper = this.mapper.orElseGet(() -> {
            ObjectMapper m4 = new ObjectMapper();
            Locale locale = env.locale();
            m4.setDateFormat(new SimpleDateFormat(config.getString("application.dateFormat"), locale));
            m4.setLocale(locale);
            m4.setTimeZone(TimeZone.getTimeZone(config.getString("application.tz")));
            m4.registerModule(new Jdk8Module());
            m4.registerModule(new JavaTimeModule());
            m4.registerModule(new ParameterNamesModule());
            m4.registerModule(new AfterburnerModule());
            return m4;
        });
        if (this.configurer != null) {
            this.configurer.accept(mapper);
        }
        binder.bind(ObjectMapper.class).toInstance(mapper);
        Multibinder<Module> mbinder = Multibinder.newSetBinder(binder, Module.class);
        this.modules.forEach(m4 -> m4.accept(mbinder));
        binder.bind(PostConfigurer.class).asEagerSingleton();
        JacksonParser parser = new JacksonParser(mapper, this.type);
        JacksonRenderer renderer = this.raw ? new JacksonRawRenderer(mapper, this.type) : new JacksonRenderer(mapper, this.type);
        Multibinder.newSetBinder(binder, Renderer.class).addBinding().toInstance(renderer);
        Multibinder.newSetBinder(binder, Parser.class).addBinding().toInstance(parser);
        binder.bind(Key.get(Renderer.class, (Annotation)Names.named(renderer.toString()))).toInstance(renderer);
        binder.bind(Key.get(Parser.class, (Annotation)Names.named(parser.toString()))).toInstance(parser);
    }

    private static class PostConfigurer {
        @Inject
        public PostConfigurer(ObjectMapper mapper, Set<Module> jacksonModules) {
            mapper.registerModules(jacksonModules);
        }
    }
}

