/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.inject.TypeLiteral;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.jooby.Parser;

public class LocalDateParser
implements Parser {
    private DateTimeFormatter formatter;

    @Inject
    public LocalDateParser(DateTimeFormatter formatter) {
        this.formatter = Objects.requireNonNull(formatter, "A date time formatter is required.");
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        if (type.getRawType() == LocalDate.class) {
            return ctx.param(values -> LocalDateParser.parse(this.formatter, (String)NOT_EMPTY.apply(values.get(0)))).body(body -> LocalDateParser.parse(this.formatter, (String)NOT_EMPTY.apply(body.text())));
        }
        return ctx.next();
    }

    public String toString() {
        return "LocalDate";
    }

    private static LocalDate parse(DateTimeFormatter formatter, String value) {
        try {
            Instant epoch = Instant.ofEpochMilli(Long.parseLong(value));
            ZonedDateTime zonedDate = epoch.atZone(Optional.ofNullable(formatter.getZone()).orElse(ZoneId.systemDefault()));
            return zonedDate.toLocalDate();
        }
        catch (NumberFormatException ex) {
            return LocalDate.parse(value, formatter);
        }
    }
}

