/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mvc;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooby.Env;
import org.jooby.MediaType;
import org.jooby.Route;
import org.jooby.funzy.Try;
import org.jooby.internal.RouteMetadata;
import org.jooby.internal.mvc.MvcHandler;
import org.jooby.internal.mvc.RequestParam;
import org.jooby.internal.mvc.RequestParamNameProviderImpl;
import org.jooby.internal.mvc.RequestParamProvider;
import org.jooby.internal.mvc.RequestParamProviderImpl;
import org.jooby.mvc.CONNECT;
import org.jooby.mvc.Consumes;
import org.jooby.mvc.DELETE;
import org.jooby.mvc.GET;
import org.jooby.mvc.HEAD;
import org.jooby.mvc.OPTIONS;
import org.jooby.mvc.PATCH;
import org.jooby.mvc.POST;
import org.jooby.mvc.PUT;
import org.jooby.mvc.Path;
import org.jooby.mvc.Produces;
import org.jooby.mvc.TRACE;

public class MvcRoutes {
    private static final String[] EMPTY = new String[0];
    private static final Set<Class<? extends Annotation>> VERBS = ImmutableSet.of(GET.class, POST.class, PUT.class, DELETE.class, PATCH.class, HEAD.class, new Class[]{OPTIONS.class, TRACE.class, CONNECT.class});
    private static final Set<Class<? extends Annotation>> IGNORE = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(VERBS)).add(Path.class)).add(Produces.class)).add(Consumes.class)).build();

    public static List<Route.Definition> routes(Env env, RouteMetadata classInfo, String rpath, boolean caseSensitiveRouting, Class<?> routeClass) {
        MvcRoutes.methods(routeClass, methods -> MvcRoutes.routes(methods, (m4, a) -> {
            if (!Modifier.isPublic(m4.getModifiers())) {
                throw new IllegalArgumentException("Not a public method: " + m4);
            }
        }));
        RequestParamProviderImpl provider = new RequestParamProviderImpl(new RequestParamNameProviderImpl(classInfo));
        String[] rootPaths = MvcRoutes.path(routeClass);
        String[] rootExcludes = MvcRoutes.excludes(routeClass, EMPTY);
        HashMap methods2 = new HashMap();
        MvcRoutes.routes(routeClass.getMethods(), methods2::put);
        ArrayList<Route.Definition> definitions = new ArrayList<Route.Definition>();
        Map<String, Object> attrs = MvcRoutes.attrs(routeClass.getAnnotations());
        methods2.keySet().stream().sorted((m1, m22) -> {
            int l1 = classInfo.startAt((Executable)m1);
            int l2 = classInfo.startAt((Executable)m22);
            return l1 - l2;
        }).forEach(method -> {
            RequestParamProvider paramProvider = provider;
            if (!env.name().equals("dev")) {
                List<RequestParam> params = provider.parameters((Executable)method);
                paramProvider = h2 -> params;
            }
            List verbs = (List)methods2.get(method);
            List<MediaType> produces = MvcRoutes.produces(method);
            List<MediaType> consumes = MvcRoutes.consumes(method);
            HashMap<String, Object> localAttrs = new HashMap<String, Object>(attrs);
            localAttrs.putAll(MvcRoutes.attrs(method.getAnnotations()));
            for (String path : MvcRoutes.expandPaths(rootPaths, method)) {
                for (Class verb : verbs) {
                    String name = routeClass.getSimpleName() + "." + method.getName();
                    String[] excludes = MvcRoutes.excludes(method, rootExcludes);
                    Route.Definition definition = ((Route.Definition)((Route.Definition)new Route.Definition(verb.getSimpleName(), rpath + "/" + path, new MvcHandler((Method)method, routeClass, paramProvider), caseSensitiveRouting).produces((List)produces)).consumes((List)consumes).excludes(excludes)).declaringClass(routeClass.getName()).line(classInfo.startAt((Executable)method) - 1).name(name);
                    localAttrs.forEach((n, v) -> definition.attr((String)n, v));
                    definitions.add(definition);
                }
            }
        });
        return definitions;
    }

    private static void methods(Class<?> clazz, Consumer<Method[]> callback) {
        if (clazz != Object.class) {
            callback.accept(clazz.getDeclaredMethods());
            MvcRoutes.methods(clazz.getSuperclass(), callback);
        }
    }

    private static void routes(Method[] methods, BiConsumer<Method, List<Class<?>>> consumer) {
        for (Method method : methods) {
            ArrayList<Class<? extends Annotation>> annotations = new ArrayList<Class<? extends Annotation>>();
            for (Class<? extends Annotation> annotationType : VERBS) {
                Annotation annotation = method.getAnnotation(annotationType);
                if (annotation == null) continue;
                annotations.add(annotationType);
            }
            if (annotations.size() > 0) {
                consumer.accept(method, annotations);
                continue;
            }
            if (!method.isAnnotationPresent(Path.class)) continue;
            consumer.accept(method, Arrays.asList(GET.class));
        }
    }

    private static Map<String, Object> attrs(Annotation[] annotations) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Annotation annotation : annotations) {
            result.putAll(MvcRoutes.attrs(annotation));
        }
        return result;
    }

    private static Map<String, Object> attrs(Annotation annotation) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (!IGNORE.contains(annotationType)) {
            Method[] attrs;
            for (Method attr : attrs = annotation.annotationType().getDeclaredMethods()) {
                Try.apply(() -> attr.invoke((Object)annotation, new Object[0])).onSuccess(value -> {
                    if (value.getClass().isArray() && Annotation.class.isAssignableFrom(value.getClass().getComponentType())) {
                        ArrayList<Map<String, Object>> array = new ArrayList<Map<String, Object>>();
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            array.add(MvcRoutes.attrs((Annotation)Array.get(value, i)));
                        }
                        result.put(MvcRoutes.attrName(annotation, attr), array.toArray());
                    } else {
                        result.put(MvcRoutes.attrName(annotation, attr), value);
                    }
                });
            }
        }
        return result;
    }

    private static String attrName(Annotation annotation, Method attr) {
        String name = attr.getName();
        String scope = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, annotation.annotationType().getSimpleName());
        if (name.equals("value")) {
            return scope;
        }
        return scope + "." + name;
    }

    private static List<MediaType> produces(Method method) {
        Function<AnnotatedElement, Optional> fn = element -> {
            Produces produces = element.getAnnotation(Produces.class);
            if (produces != null) {
                return Optional.of(MediaType.valueOf(produces.value()));
            }
            return Optional.empty();
        };
        return fn.apply(method).orElseGet(() -> ((Optional)fn.apply(method.getDeclaringClass())).orElse(MediaType.ALL));
    }

    private static List<MediaType> consumes(Method method) {
        Function<AnnotatedElement, Optional> fn = element -> {
            Consumes consumes = element.getAnnotation(Consumes.class);
            if (consumes != null) {
                return Optional.of(MediaType.valueOf(consumes.value()));
            }
            return Optional.empty();
        };
        return fn.apply(method).orElseGet(() -> ((Optional)fn.apply(method.getDeclaringClass())).orElse(MediaType.ALL));
    }

    private static String[] path(AnnotatedElement owner) {
        Path annotation = owner.getAnnotation(Path.class);
        if (annotation == null) {
            return EMPTY;
        }
        return annotation.value();
    }

    private static String[] excludes(AnnotatedElement owner, String[] parent) {
        Path annotation = owner.getAnnotation(Path.class);
        if (annotation == null) {
            return parent;
        }
        String[] excludes = annotation.excludes();
        if (excludes.length == 0) {
            return parent;
        }
        if (parent.length == 0) {
            return excludes;
        }
        int size = parent.length + excludes.length;
        String[] result = new String[size];
        System.arraycopy(parent, 0, result, 0, parent.length);
        System.arraycopy(excludes, 0, result, parent.length, excludes.length);
        return result;
    }

    private static String[] expandPaths(String[] root, Method m4) {
        String[] path = MvcRoutes.path(m4);
        if (root.length == 0) {
            if (path.length == 0) {
                throw new IllegalArgumentException("No path(s) found for: " + m4);
            }
            return path;
        }
        if (path.length == 0) {
            return root;
        }
        String[] result = new String[root.length * path.length];
        int k = 0;
        for (String base : root) {
            for (String element : path) {
                result[k] = base + "/" + element;
                ++k;
            }
        }
        return result;
    }
}

