/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import java.util.Optional;
import java.util.function.Predicate;

public class SourceProvider {
    private static final Predicate<String> JOOBY_PKG = SourceProvider.pkg("org.jooby");
    private static final Predicate<String> JAVALANG_PKG = SourceProvider.pkg("javaslang");
    private static final Predicate<String> GOOGLE_PKG = SourceProvider.pkg("com.google");
    private static final Predicate<String> SUN_PKG = SourceProvider.pkg("sun.").or(SourceProvider.pkg("com.sun"));
    private static final Predicate<String> JAVA_PKG = SourceProvider.pkg("java.");
    private static final Predicate<String> SKIP = JOOBY_PKG.or(GOOGLE_PKG).or(JAVALANG_PKG).or(SUN_PKG).or(JAVA_PKG);
    public static final SourceProvider INSTANCE = new SourceProvider(SKIP);
    private final Predicate<String> skip;

    private SourceProvider(Predicate<String> skip) {
        this.skip = skip;
    }

    public Optional<StackTraceElement> get() {
        return this.get(new Throwable().getStackTrace());
    }

    public Optional<StackTraceElement> get(StackTraceElement[] elements) {
        for (StackTraceElement element : elements) {
            String className = element.getClassName();
            if (this.skip.test(className)) continue;
            int innerStart = className.indexOf(36);
            if (innerStart > 0) {
                return Optional.of(new StackTraceElement(className.substring(0, innerStart), element.getMethodName(), element.getFileName(), element.getLineNumber()));
            }
            return Optional.of(element);
        }
        return Optional.empty();
    }

    private static Predicate<String> pkg(String pkg) {
        return classname -> classname.startsWith(pkg);
    }
}

