/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.Map;

public class RequestScope
implements Scope {
    private final ThreadLocal<Map<Object, Object>> scope = new ThreadLocal();

    public void enter(Map<Object, Object> locals) {
        this.scope.set(locals);
    }

    public void exit() {
        this.scope.remove();
    }

    @Override
    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return () -> {
            Map<Object, Object> scopedObjects = this.getScopedObjectMap(key);
            Object current = scopedObjects.get(key);
            if (current == null && !scopedObjects.containsKey(key)) {
                current = unscoped.get();
                if (Scopes.isCircularProxy(current)) {
                    return current;
                }
                scopedObjects.put(key, current);
            }
            if (current instanceof javax.inject.Provider && !javax.inject.Provider.class.isAssignableFrom(key.getTypeLiteral().getRawType())) {
                return ((javax.inject.Provider)current).get();
            }
            return current;
        };
    }

    private <T> Map<Object, Object> getScopedObjectMap(Key<T> key) {
        Map<Object, Object> scopedObjects = this.scope.get();
        if (scopedObjects == null) {
            throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
        }
        return scopedObjects;
    }
}

