/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jooby.Cookie;
import org.jooby.Env;
import org.jooby.Err;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Session;
import org.jooby.Status;
import org.jooby.Upload;
import org.jooby.funzy.Try;
import org.jooby.internal.BodyReferenceImpl;
import org.jooby.internal.EmptyBodyReference;
import org.jooby.internal.LocaleUtils;
import org.jooby.internal.MutantImpl;
import org.jooby.internal.RequestScopedSession;
import org.jooby.internal.RoutePattern;
import org.jooby.internal.SessionImpl;
import org.jooby.internal.SessionManager;
import org.jooby.internal.StrParamReferenceImpl;
import org.jooby.internal.UploadImpl;
import org.jooby.internal.parser.ParserExecutor;
import org.jooby.spi.NativeRequest;
import org.jooby.spi.NativeUpload;

public class RequestImpl
implements Request {
    private final Map<String, Mutant> params = new HashMap<String, Mutant>();
    private final List<MediaType> accept;
    private final MediaType type;
    private final Injector injector;
    private final NativeRequest req;
    private final Map<Object, Object> scope;
    private final Map<String, Object> locals;
    private Route route;
    private Optional<Session> reqSession;
    private Charset charset;
    private List<File> files;
    private int port;
    private String contextPath;
    private Optional<String> lang;
    private List<Locale> locales;
    private long timestamp;

    public RequestImpl(Injector injector, NativeRequest req, String contextPath, int port, Route route, Charset charset, List<Locale> locales, Map<Object, Object> scope, Map<String, Object> locals, long timestamp) {
        this.injector = injector;
        this.req = req;
        this.route = route;
        this.scope = scope;
        this.locals = locals;
        this.contextPath = contextPath;
        Optional<String> accept = req.header("Accept");
        this.accept = accept.isPresent() ? MediaType.parse(accept.get()) : MediaType.ALL;
        this.lang = req.header("Accept-Language");
        this.locales = locales;
        this.port = port;
        Optional<String> type = req.header("Content-Type");
        this.type = type.isPresent() ? MediaType.valueOf(type.get()) : MediaType.all;
        String cs = this.type.params().get("charset");
        this.charset = cs != null ? Charset.forName(cs) : charset;
        this.files = new ArrayList<File>();
        this.timestamp = timestamp;
    }

    @Override
    public String contextPath() {
        return this.contextPath;
    }

    @Override
    public Optional<String> queryString() {
        return this.req.queryString();
    }

    @Override
    public <T> Optional<T> ifGet(String name) {
        Objects.requireNonNull(name, "A local's name is required.");
        return Optional.ofNullable(this.locals.get(name));
    }

    @Override
    public boolean matches(String pattern) {
        RoutePattern p = new RoutePattern("*", pattern);
        return p.matcher(this.route.path()).matches();
    }

    @Override
    public Map<String, Object> attributes() {
        return Collections.unmodifiableMap(this.locals);
    }

    @Override
    public <T> Optional<T> unset(String name) {
        Objects.requireNonNull(name, "A local's name is required.");
        return Optional.ofNullable(this.locals.remove(name));
    }

    @Override
    public MediaType type() {
        return this.type;
    }

    @Override
    public List<MediaType> accept() {
        return this.accept;
    }

    @Override
    public Optional<MediaType> accepts(List<MediaType> types) {
        Objects.requireNonNull(types, "Media types are required.");
        return MediaType.matcher(this.accept()).first(types);
    }

    @Override
    public Mutant params(String ... xss) {
        return this._params(this.xss(xss));
    }

    @Override
    public Mutant params() {
        return this._params(null);
    }

    private Mutant _params(Function<String, String> xss) {
        HashMap<String, Mutant> params = new HashMap<String, Mutant>();
        for (Object segment : this.route.vars().keySet()) {
            if (!(segment instanceof String)) continue;
            String name = (String)segment;
            params.put(name, this._param(name, xss));
        }
        for (String name : this.paramNames()) {
            params.put(name, this._param(name, xss));
        }
        return new MutantImpl(this.require(ParserExecutor.class), params);
    }

    @Override
    public Mutant param(String name, String ... xss) {
        return this._param(name, this.xss(xss));
    }

    @Override
    public Mutant param(String name) {
        return this._param(name, null);
    }

    @Override
    public List<Upload> files(String name) throws IOException {
        List<NativeUpload> files = this.req.files(name);
        List<Upload> uploads = files.stream().map(upload -> new UploadImpl(this.injector, (NativeUpload)upload)).collect(Collectors.toList());
        return uploads;
    }

    @Override
    public List<Upload> files() throws IOException {
        return this.req.files().stream().map(upload -> new UploadImpl(this.injector, (NativeUpload)upload)).collect(Collectors.toList());
    }

    private Mutant _param(String name, Function<String, String> xss) {
        Mutant param = this.params.get(name);
        if (param == null) {
            StrParamReferenceImpl paramref = new StrParamReferenceImpl("parameter", name, this.params(name, xss));
            param = new MutantImpl(this.require(ParserExecutor.class), paramref);
            if (paramref.size() > 0) {
                this.params.put(name, param);
            }
        }
        return param;
    }

    @Override
    public Mutant header(String name) {
        return this._header(name, null);
    }

    @Override
    public Mutant header(String name, String ... xss) {
        return this._header(name, this.xss(xss));
    }

    private Mutant _header(String name, Function<String, String> xss) {
        Objects.requireNonNull(name, "Name required.");
        List<String> headers = this.req.headers(name);
        if (xss != null) {
            headers = headers.stream().map(xss::apply).collect(Collectors.toList());
        }
        return new MutantImpl(this.require(ParserExecutor.class), new StrParamReferenceImpl("header", name, headers));
    }

    @Override
    public Map<String, Mutant> headers() {
        LinkedHashMap<String, Mutant> headers = new LinkedHashMap<String, Mutant>();
        this.req.headerNames().forEach(name -> headers.put((String)name, this.header((String)name)));
        return headers;
    }

    @Override
    public Mutant cookie(String name) {
        List values = this.req.cookies().stream().filter(c -> c.name().equalsIgnoreCase(name)).findFirst().map(cookie -> ImmutableList.of(cookie.value().orElse(""))).orElse(ImmutableList.of());
        return new MutantImpl(this.require(ParserExecutor.class), new StrParamReferenceImpl("cookie", name, values));
    }

    @Override
    public List<Cookie> cookies() {
        return this.req.cookies();
    }

    @Override
    public Mutant body() throws Exception {
        long length = this.length();
        if (length > 0L) {
            MediaType type = this.type();
            Config conf = this.require(Config.class);
            File fbody = new File(conf.getString("application.tmpdir"), Integer.toHexString(System.identityHashCode(this)));
            this.files.add(fbody);
            int bufferSize = conf.getBytes("server.http.RequestBufferSize").intValue();
            BodyReferenceImpl body = new BodyReferenceImpl(length, this.charset(), fbody, this.req.in(), bufferSize);
            return new MutantImpl(this.require(ParserExecutor.class), type, body);
        }
        return new MutantImpl(this.require(ParserExecutor.class), this.type, new EmptyBodyReference());
    }

    @Override
    public <T> T require(Key<T> key) {
        return this.injector.getInstance(key);
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public long length() {
        return this.req.header("Content-Length").map(Long::parseLong).orElse(-1L);
    }

    @Override
    public List<Locale> locales(BiFunction<List<Locale.LanguageRange>, List<Locale>, List<Locale>> filter) {
        return this.lang.map(h2 -> (List)filter.apply(LocaleUtils.range(h2), this.locales)).orElseGet(() -> (List)filter.apply(ImmutableList.of(), this.locales));
    }

    @Override
    public Locale locale(BiFunction<List<Locale.LanguageRange>, List<Locale>, Locale> filter) {
        Supplier<Locale> def = () -> (Locale)filter.apply(ImmutableList.of(), this.locales);
        return this.lang.map(h2 -> Try.apply(() -> (Locale)filter.apply(LocaleUtils.range(h2), this.locales)).orElseGet(def)).orElseGet(def);
    }

    @Override
    public String ip() {
        return this.req.ip();
    }

    @Override
    public Route route() {
        return this.route;
    }

    @Override
    public String rawPath() {
        return this.req.rawPath();
    }

    @Override
    public String hostname() {
        return this.req.header("host").map(host -> host.split(":")[0]).orElse(this.ip());
    }

    @Override
    public int port() {
        return this.req.header("host").map(host -> {
            String[] parts = host.split(":");
            if (parts.length > 1) {
                return Integer.parseInt(parts[1]);
            }
            return this.secure() ? 443 : 80;
        }).orElse(this.port);
    }

    @Override
    public Session session() {
        return this.ifSession().orElseGet(() -> {
            SessionManager sm = this.require(SessionManager.class);
            Response rsp = this.require(Response.class);
            Session gsession = sm.create(this, rsp);
            return this.setSession(sm, rsp, gsession);
        });
    }

    @Override
    public Optional<Session> ifSession() {
        if (this.reqSession == null) {
            Response rsp;
            SessionManager sm = this.require(SessionManager.class);
            Session gsession = sm.get(this, rsp = this.require(Response.class));
            if (gsession == null) {
                this.reqSession = Optional.empty();
            } else {
                this.setSession(sm, rsp, gsession);
            }
        }
        return this.reqSession;
    }

    @Override
    public String protocol() {
        return this.req.protocol();
    }

    @Override
    public boolean secure() {
        return this.req.secure();
    }

    @Override
    public Request set(String name, Object value) {
        Objects.requireNonNull(name, "A local's name is required.");
        Objects.requireNonNull(value, "A local's value is required.");
        this.locals.put(name, value);
        return this;
    }

    @Override
    public Request set(Key<?> key, Object value) {
        Objects.requireNonNull(key, "A local's jey is required.");
        Objects.requireNonNull(value, "A local's value is required.");
        this.scope.put(key, value);
        return this;
    }

    @Override
    public Request push(String path, Map<String, Object> headers) {
        if (this.protocol().equalsIgnoreCase("HTTP/2.0")) {
            this.require(Response.class).after((req, rsp, value) -> {
                this.req.push("GET", this.contextPath + path, headers);
                return value;
            });
            return this;
        }
        throw new UnsupportedOperationException("Push promise not available");
    }

    public String toString() {
        return this.route().toString();
    }

    private List<String> paramNames() {
        try {
            return this.req.paramNames();
        }
        catch (Exception ex) {
            throw new Err(Status.BAD_REQUEST, "Unable to get parameter names", (Throwable)ex);
        }
    }

    private Function<String, String> xss(String ... xss) {
        return this.require(Env.class).xss(xss);
    }

    private List<String> params(String name, Function<String, String> xss) {
        try {
            ArrayList<String> values = new ArrayList<String>();
            String pathvar = this.route.vars().get(name);
            if (pathvar != null) {
                values.add(pathvar);
            }
            values.addAll(this.req.params(name));
            if (xss == null) {
                return values;
            }
            for (int i = 0; i < values.size(); ++i) {
                values.set(i, xss.apply((String)values.get(i)));
            }
            return values;
        }
        catch (Throwable ex) {
            throw new Err(Status.BAD_REQUEST, "Parameter '" + name + "' resulted in error", ex);
        }
    }

    void route(Route route) {
        this.route = route;
    }

    public void done() {
        if (this.reqSession != null) {
            this.reqSession.ifPresent(session -> this.require(SessionManager.class).requestDone((Session)session));
        }
        if (this.files.size() > 0) {
            for (File file : this.files) {
                file.delete();
            }
        }
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    private Session setSession(SessionManager sm, Response rsp, Session gsession) {
        RequestScopedSession rsession = new RequestScopedSession(sm, rsp, (SessionImpl)gsession, this::destroySession);
        this.reqSession = Optional.of(rsession);
        return rsession;
    }

    private void destroySession() {
        this.reqSession = Optional.empty();
    }
}

