/*
 * Decompiled with CFR 0.152.
 */
package org.jooby;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.jooby.MediaType;
import org.jooby.Mutant;
import org.jooby.internal.parser.BeanParser;

public interface Parser {
    public static final Function<String, String> NOT_EMPTY = v -> {
        if (v.length() == 0) {
            throw new NoSuchElementException();
        }
        return v;
    };

    public Object parse(TypeLiteral<?> var1, Context var2) throws Throwable;

    public static Parser bean(boolean lenient) {
        return new BeanParser(lenient);
    }

    public static interface Context
    extends Builder {
        public <T> T require(Class<T> var1);

        public <T> T require(TypeLiteral<T> var1);

        public <T> T require(Key<T> var1);

        public MediaType type();

        public Object next() throws Throwable;

        public Object next(TypeLiteral<?> var1) throws Throwable;

        public Object next(TypeLiteral<?> var1, Object var2) throws Throwable;
    }

    public static interface Builder {
        public Builder body(Callback<BodyReference> var1);

        public Builder ifbody(Callback<BodyReference> var1);

        public Builder param(Callback<ParamReference<String>> var1);

        public Builder ifparam(Callback<ParamReference<String>> var1);

        public Builder params(Callback<Map<String, Mutant>> var1);

        public Builder ifparams(Callback<Map<String, Mutant>> var1);
    }

    public static interface BodyReference {
        public byte[] bytes() throws IOException;

        public String text() throws IOException;

        public long length();

        public void writeTo(OutputStream var1) throws Exception;
    }

    public static interface ParamReference<T>
    extends Iterable<T> {
        public String type();

        public String name();

        public T first();

        public T last();

        public T get(int var1);

        @Override
        public Iterator<T> iterator();

        public int size();
    }

    public static interface Callback<T> {
        public Object invoke(T var1) throws Throwable;
    }
}

