/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.command;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import io.airlift.command.CommandFailedException;
import io.airlift.command.CommandResult;
import io.airlift.command.CommandTimeoutException;
import io.airlift.command.ProcessCallable;
import io.airlift.units.Duration;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Command {
    private static final ImmutableSet<Integer> DEFAULT_SUCCESSFUL_EXIT_CODES = ImmutableSet.of(Integer.valueOf(0));
    private static final File DEFAULT_DIRECTORY = new File(".").getAbsoluteFile();
    private static final Duration DEFAULT_TIME_LIMIT = new Duration(365.0, TimeUnit.DAYS);
    private final List<String> command;
    private final Set<Integer> successfulExitCodes;
    private final File directory;
    private final Map<String, String> environment;
    private final Duration timeLimit;

    public Command(String ... command) {
        this(ImmutableList.copyOf(command), DEFAULT_SUCCESSFUL_EXIT_CODES, DEFAULT_DIRECTORY, ImmutableMap.of(), DEFAULT_TIME_LIMIT);
    }

    public Command(List<String> command, Set<Integer> successfulExitCodes, File directory, Map<String, String> environment, Duration timeLimit) {
        Objects.requireNonNull(command, "command is null");
        Preconditions.checkArgument(!command.isEmpty(), "command is empty");
        Objects.requireNonNull(successfulExitCodes, "successfulExitCodes is null");
        Preconditions.checkArgument(!successfulExitCodes.isEmpty(), "successfulExitCodes is empty");
        Objects.requireNonNull(directory, "directory is null");
        Objects.requireNonNull(timeLimit, "timeLimit is null");
        this.command = ImmutableList.copyOf(command);
        this.successfulExitCodes = ImmutableSet.copyOf(successfulExitCodes);
        this.directory = directory;
        this.environment = ImmutableMap.copyOf(environment);
        this.timeLimit = timeLimit;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public Command addArgs(String ... args) {
        Objects.requireNonNull(args, "args is null");
        return this.addArgs(ImmutableList.copyOf(args));
    }

    public Command addArgs(Iterable<String> args) {
        Objects.requireNonNull(args, "args is null");
        ImmutableCollection.Builder command = ((ImmutableList.Builder)ImmutableList.builder().addAll(this.command)).addAll(args);
        return new Command((List<String>)((Object)((ImmutableList.Builder)command).build()), this.successfulExitCodes, this.directory, this.environment, this.timeLimit);
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Command addEnvironment(String name, String value) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(this.environment).put(name, value);
        return new Command(this.command, this.successfulExitCodes, this.directory, builder.build(), this.timeLimit);
    }

    public Command addEnvironment(Map<String, String> environment) {
        Objects.requireNonNull(environment, "environment is null");
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder().putAll(this.environment).putAll(environment);
        return new Command(this.command, this.successfulExitCodes, this.directory, builder.build(), this.timeLimit);
    }

    public Set<Integer> getSuccessfulExitCodes() {
        return this.successfulExitCodes;
    }

    public Command setSuccessfulExitCodes(int ... successfulExitCodes) {
        Objects.requireNonNull(successfulExitCodes, "successfulExitCodes is null");
        return this.setSuccessfulExitCodes(ImmutableSet.copyOf(Ints.asList(successfulExitCodes)));
    }

    public Command setSuccessfulExitCodes(Set<Integer> successfulExitCodes) {
        Objects.requireNonNull(successfulExitCodes, "successfulExitCodes is null");
        Preconditions.checkArgument(!successfulExitCodes.isEmpty(), "successfulExitCodes is empty");
        return new Command(this.command, successfulExitCodes, this.directory, this.environment, this.timeLimit);
    }

    public File getDirectory() {
        return this.directory;
    }

    public Command setDirectory(String directory) {
        Objects.requireNonNull(directory, "directory is null");
        return this.setDirectory(new File(directory));
    }

    public Command setDirectory(File directory) {
        Objects.requireNonNull(directory, "directory is null");
        return new Command(this.command, this.successfulExitCodes, directory, this.environment, this.timeLimit);
    }

    public Duration getTimeLimit() {
        return this.timeLimit;
    }

    public Command setTimeLimit(double value, TimeUnit timeUnit) {
        return this.setTimeLimit(new Duration(value, timeUnit));
    }

    public Command setTimeLimit(Duration timeLimit) {
        Objects.requireNonNull(timeLimit, "timeLimit is null");
        return new Command(this.command, this.successfulExitCodes, this.directory, this.environment, timeLimit);
    }

    public CommandResult execute(Executor executor) throws CommandFailedException {
        ProcessCallable processCallable = new ProcessCallable(this, executor);
        ListenableFuture<CommandResult> future = Command.submit(executor, processCallable);
        try {
            CommandResult commandResult = (CommandResult)future.get(this.timeLimit.toMillis(), TimeUnit.MILLISECONDS);
            return commandResult;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause(), CommandFailedException.class);
            throw new CommandFailedException(this, "unexpected exception", e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommandFailedException(this, "interrupted", e);
        }
        catch (TimeoutException e) {
            throw new CommandTimeoutException(this);
        }
        finally {
            future.cancel(true);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Command o = (Command)obj;
        return Objects.equals(this.command, o.command) && Objects.equals(this.successfulExitCodes, o.successfulExitCodes) && Objects.equals(this.directory, o.directory) && Objects.equals(this.timeLimit, o.timeLimit);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.successfulExitCodes, this.directory, this.timeLimit);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("command", this.command).add("successfulExitCodes", this.successfulExitCodes).add("directory", this.directory).add("timeLimit", this.timeLimit).toString();
    }

    static <T> ListenableFuture<T> submit(Executor executor, Callable<T> task) {
        ListenableFutureTask<T> future = ListenableFutureTask.create(task);
        executor.execute(future);
        return future;
    }
}

