/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.lifecycle;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.SortedSet;
import org.killbill.billing.lifecycle.DefaultLifecycle;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLifecycle {
    private static final Logger log = LoggerFactory.getLogger(TestLifecycle.class);
    private Service1 s1;
    private Service2 s2;
    private DefaultLifecycle lifecycle;

    public KillbillService createKillBillService(final String name, final int order) {
        return new KillbillService(){

            public String getName() {
                return name;
            }

            public int getRegistrationOrdering() {
                return order;
            }

            @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
            @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
            public void initService() {
            }
        };
    }

    @BeforeClass(groups={"fast"})
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    public void setup() {
        Injector g = Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{new TestLifecycleModule()});
        this.s1 = (Service1)g.getInstance(Service1.class);
        this.s2 = (Service2)g.getInstance(Service2.class);
        KillbillService s = this.createKillBillService("foo", 3);
        this.lifecycle = (DefaultLifecycle)g.getInstance(DefaultLifecycle.class);
    }

    @Test(groups={"fast"})
    public void testLifecycle() {
        this.s1.reset();
        this.s2.reset();
        this.lifecycle.fireStartupSequencePriorEventRegistration();
        Assert.assertEquals((int)(this.s1.getCount() + this.s2.getCount()), (int)3);
        this.s1.reset();
        this.s2.reset();
        this.lifecycle.fireStartupSequencePostEventRegistration();
        Assert.assertEquals((int)(this.s1.getCount() + this.s2.getCount()), (int)2);
        this.s1.reset();
        this.s2.reset();
        this.lifecycle.fireShutdownSequencePriorEventUnRegistration();
        Assert.assertEquals((int)(this.s1.getCount() + this.s2.getCount()), (int)1);
        this.s1.reset();
        this.s2.reset();
        this.lifecycle.fireShutdownSequencePostEventUnRegistration();
        Assert.assertEquals((int)(this.s1.getCount() + this.s2.getCount()), (int)1);
    }

    @Test(groups={"fast"})
    public void testHandlersOrdering() {
        HashSet<KillbillService> services = new HashSet<KillbillService>();
        for (int i = 0; i < 100; ++i) {
            int order = (i + 37) % 100;
            services.add(this.createKillBillService(String.format("yo-%d", order), order));
        }
        DefaultLifecycle otherLifecycle = new DefaultLifecycle(services);
        SortedSet handlers = otherLifecycle.getHandlersByLevel().get((Object)LifecycleHandlerType.LifecycleLevel.INIT_SERVICE);
        int prevOrdering = -1;
        for (DefaultLifecycle.LifecycleHandler h : handlers) {
            Assert.assertTrue((h.getTarget().getRegistrationOrdering() > prevOrdering ? 1 : 0) != 0);
            ++prevOrdering;
        }
    }

    public static class TestLifecycleModule
    extends AbstractModule {
        protected void configure() {
            this.bind(DefaultLifecycle.class).to(LifecycleNoWarn.class).asEagerSingleton();
            this.bind(TestService1Interface.class).to(Service1.class);
            this.bind(Service1.class).asEagerSingleton();
            this.bind(Service2.class).asEagerSingleton();
            this.bind(TestService2Interface.class).to(Service2.class);
        }
    }

    public static class LifecycleNoWarn
    extends DefaultLifecycle {
        @Inject
        public LifecycleNoWarn(Injector injector) {
            super(injector);
        }

        protected void logWarn(String msg, Exception e) {
        }
    }

    public static class Service2
    extends ServiceBase
    implements TestService2Interface {
        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.LOAD_CATALOG)
        public void loadCatalog() {
            log.info("Service2 : got LOAD_CATALOG");
            this.incrementCount();
        }

        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
        public void registerEvents() {
            log.info("Service2 : got REGISTER_EVENTS");
            this.incrementCount();
        }

        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
        public void unregisterEvents() {
            log.info("Service2 : got UNREGISTER_EVENTS");
            this.incrementCount();
        }

        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
        public void startService() {
            log.info("Service2 : got START_SERVICE");
            this.incrementCount();
        }

        public String getName() {
            return null;
        }

        public int getRegistrationOrdering() {
            return 1000;
        }
    }

    public static interface TestService2Interface
    extends KillbillService {
    }

    public static class Service1
    extends ServiceBase
    implements TestService1Interface {
        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_BUS)
        public void initBus() {
            log.info("Service1 : got INIT_BUS");
            this.incrementCount();
        }

        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
        public void startService() {
            log.info("Service1 : got START_SERVICE");
            this.incrementCount();
        }

        @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.SHUTDOWN)
        public void shutdownService() {
            log.info("Service1 : got SHUTDOWN");
            this.incrementCount();
        }

        public String getName() {
            return null;
        }

        public int getRegistrationOrdering() {
            return 1000;
        }
    }

    public static interface TestService1Interface
    extends KillbillService {
    }

    public static class ServiceBase {
        private int count = 0;

        public ServiceBase() {
            this.reset();
        }

        public synchronized void reset() {
            this.count = 0;
        }

        public synchronized int getCount() {
            return this.count;
        }

        public synchronized void incrementCount() {
            ++this.count;
        }
    }
}

