/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.config;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.killbill.billing.platform.config.DefaultKillbillConfigSource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultKillbillConfigSource {
    private static final String ENABLE_JASYPT_PROPERTY = "org.killbill.server.enableJasypt";
    private static final String JASYPT_ENCRYPTOR_PASSWORD_PROPERTY = "JASYPT_ENCRYPTOR_PASSWORD";
    private static final String JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY = "JASYPT_ENCRYPTOR_ALGORITHM";
    private static final String JASYPT_PASSWORD = "top_secret!";
    private static final String JASYPT_ALGORITHM = "PBEWITHMD5ANDDES";
    private static final String ENCRYPTED_PROPERTY_1 = "test.encrypted.property1";
    private static final String ENCRYPTED_PROPERTY_2 = "test.encrypted.property2";

    @BeforeMethod(groups={"fast"})
    public void setup() {
        System.clearProperty(ENABLE_JASYPT_PROPERTY);
        System.clearProperty(JASYPT_PASSWORD);
        System.clearProperty(JASYPT_ALGORITHM);
        System.clearProperty(ENCRYPTED_PROPERTY_1);
        System.clearProperty(ENCRYPTED_PROPERTY_2);
    }

    @Test(groups={"fast"})
    public void testGetProperties() throws URISyntaxException, IOException {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("1", "A");
        configuration.put("2", "B");
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource(null, configuration);
        Assert.assertNotNull((Object)configSource.getProperties());
        Assert.assertNotEquals((Object)configSource.getProperties().size(), (Object)0);
        Assert.assertEquals((String)configSource.getProperties().getProperty("1"), (String)"A");
    }

    @Test(groups={"fast"})
    public void testFromEnvVariableName() throws IOException, URISyntaxException {
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource();
        Assert.assertEquals((String)configSource.fromEnvVariableName(""), (String)"");
        Assert.assertEquals((String)configSource.fromEnvVariableName("KB_org_killbill_billing_osgi_dao_prepStmtCacheSize"), (String)"org.killbill.billing.osgi.dao.prepStmtCacheSize");
        Assert.assertEquals((String)configSource.fromEnvVariableName("KB_org_killbill_billing_osgi_dao__prepStmtCacheSize"), (String)"org.killbill.billing.osgi.dao..prepStmtCacheSize");
    }

    @Test(groups={"fast"})
    public void testJasyptDisabledByDefault() throws IOException, URISyntaxException {
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource();
        String enableJasyptString = configSource.getString(ENABLE_JASYPT_PROPERTY);
        Assert.assertFalse((boolean)Boolean.parseBoolean(enableJasyptString));
    }

    @Test(groups={"fast"})
    public void testDecyptionExplicitlyDisabled() throws IOException, URISyntaxException {
        String unencryptedValue = "myPropertyValue";
        String encryptedValue = this.encString("myPropertyValue");
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "false", ENCRYPTED_PROPERTY_1, encryptedValue, JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, JASYPT_PASSWORD, JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, JASYPT_ALGORITHM);
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource(properties);
        String actualValue = configSource.getString(ENCRYPTED_PROPERTY_1);
        Assert.assertEquals((String)encryptedValue, (String)actualValue);
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalArgumentException.class})
    public void testDecryptEmptyPassword() throws IOException, URISyntaxException {
        String encryptedValue = this.encString("myPropertyValue");
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "true", ENCRYPTED_PROPERTY_1, encryptedValue, JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, "", JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource(properties);
    }

    @Test(groups={"fast"}, expectedExceptions={IllegalArgumentException.class})
    public void testDecryptEmptyAlgorithm() throws IOException, URISyntaxException {
        String encryptedValue = this.encString("myPropertyValue");
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "true", ENCRYPTED_PROPERTY_1, encryptedValue, JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, JASYPT_PASSWORD, JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, "");
        new DefaultKillbillConfigSource(properties);
    }

    @Test(groups={"fast"}, expectedExceptions={EncryptionOperationNotPossibleException.class})
    public void testDecryptInvalidJasyptString() throws IOException, URISyntaxException {
        String encryptedValue = "ENC(notAValidEncryptedString!)";
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "true", ENCRYPTED_PROPERTY_1, "ENC(notAValidEncryptedString!)", JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, JASYPT_PASSWORD, JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource(properties);
    }

    @Test(groups={"fast"}, expectedExceptions={EncryptionOperationNotPossibleException.class})
    public void testDecryptEmptyJasyptString() throws IOException, URISyntaxException {
        String encryptedValue = "ENC()";
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "true", ENCRYPTED_PROPERTY_1, "ENC()", JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, JASYPT_PASSWORD, JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, JASYPT_ALGORITHM);
        new DefaultKillbillConfigSource(properties);
    }

    @Test(groups={"fast"})
    public void testDecryptJasyptPropertySuccessfully() throws IOException, URISyntaxException {
        String unencryptedValue1 = "myPropertyValue";
        String encryptedValue1 = this.encString("myPropertyValue");
        String unencryptedValue2 = "myOtherPropertyValue";
        String encryptedValue2 = this.encString("myOtherPropertyValue");
        Map<String, String> properties = Map.of(ENABLE_JASYPT_PROPERTY, "true", ENCRYPTED_PROPERTY_1, encryptedValue1, ENCRYPTED_PROPERTY_2, encryptedValue2, JASYPT_ENCRYPTOR_PASSWORD_PROPERTY, JASYPT_PASSWORD, JASYPT_ENCRYPTOR_ALGORITHM_PROPERTY, JASYPT_ALGORITHM);
        DefaultKillbillConfigSource configSource = new DefaultKillbillConfigSource(properties);
        String actualValue1 = configSource.getString(ENCRYPTED_PROPERTY_1);
        String actualValue2 = configSource.getString(ENCRYPTED_PROPERTY_2);
        Assert.assertEquals((String)"myPropertyValue", (String)actualValue1);
        Assert.assertEquals((String)"myOtherPropertyValue", (String)actualValue2);
    }

    private String encString(String unencryptedValue) {
        return "ENC(" + this.encrypt(unencryptedValue, JASYPT_ALGORITHM, JASYPT_PASSWORD) + ")";
    }

    private String encrypt(String unencryptedValue, String jasyptAlgorithm, String jasyptPassword) {
        StandardPBEStringEncryptor encryptor = this.setupEncryptor(jasyptPassword, jasyptAlgorithm);
        return encryptor.encrypt(unencryptedValue);
    }

    private StandardPBEStringEncryptor setupEncryptor(String password, String algorithm) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword(password);
        encryptor.setAlgorithm(algorithm);
        return encryptor;
    }
}

