/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.jndi;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.log4jdbc.log.SpyLogFactory;
import org.h2.jdbcx.JdbcDataSource;
import org.killbill.billing.platform.jndi.JNDIManager;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpy;
import org.killbill.commons.embeddeddb.EmbeddedDB;
import org.killbill.commons.embeddeddb.h2.H2EmbeddedDB;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestJNDIManager {
    EmbeddedDB embeddedDB;

    @BeforeMethod(groups={"slow"})
    public void setUp() throws Exception {
        SpyLogFactory.loadSpyLogDelegator((String)"net.sf.log4jdbc.log.slf4j.Slf4jSpyLogDelegator");
        String databaseName = "killbillosgitests";
        this.embeddedDB = new H2EmbeddedDB("killbillosgitests", UUID.randomUUID().toString(), UUID.randomUUID().toString(), "jdbc:h2:mem:killbillosgitests;DB_CLOSE_ON_EXIT=FALSE");
        this.embeddedDB.initialize();
        this.embeddedDB.start();
    }

    @AfterMethod(groups={"slow"})
    public void tearDown() throws Exception {
        this.embeddedDB.stop();
    }

    @Test(groups={"slow"})
    public void testExportAndLookup() throws NamingException, IOException, SQLException {
        JNDIManager jndiManager = new JNDIManager();
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL(this.embeddedDB.getJdbcConnectionString());
        dataSource.setUser(this.embeddedDB.getUsername());
        dataSource.setPassword(this.embeddedDB.getPassword());
        JdbcDataSource retrievedJdbcDataSource = this.testForDataSource(jndiManager, (DataSource)dataSource, JdbcDataSource.class);
        Assert.assertEquals((String)retrievedJdbcDataSource.getURL(), (String)this.embeddedDB.getJdbcConnectionString());
        Assert.assertEquals((String)retrievedJdbcDataSource.getUser(), (String)this.embeddedDB.getUsername());
        Assert.assertEquals((String)retrievedJdbcDataSource.getPassword(), (String)this.embeddedDB.getPassword());
        Assert.assertNotNull((Object)retrievedJdbcDataSource.getConnection());
        ReferenceableDataSourceSpy retrievedReferenceableDataSourceSpy = this.testForDataSource(jndiManager, (DataSource)new ReferenceableDataSourceSpy((DataSource)dataSource, "something"), ReferenceableDataSourceSpy.class);
        DataSource retrievedJdbcDataSource2Delegate = retrievedReferenceableDataSourceSpy.getDataSource();
        Assert.assertTrue((boolean)(retrievedJdbcDataSource2Delegate instanceof JdbcDataSource));
        JdbcDataSource retrievedJdbcDataSource2 = (JdbcDataSource)retrievedJdbcDataSource2Delegate;
        Assert.assertEquals((String)retrievedJdbcDataSource2.getURL(), (String)this.embeddedDB.getJdbcConnectionString());
        Assert.assertEquals((String)retrievedJdbcDataSource2.getUser(), (String)this.embeddedDB.getUsername());
        Assert.assertEquals((String)retrievedJdbcDataSource2.getPassword(), (String)this.embeddedDB.getPassword());
        Assert.assertNotNull((Object)retrievedJdbcDataSource2.getConnection());
    }

    private <T> T testForDataSource(JNDIManager jndiManager, DataSource dataSource, Class<T> klass) {
        String name = "a/b/c";
        jndiManager.export("a/b/c", (Object)dataSource);
        Object retrievedDataSourceObject = jndiManager.lookup("a/b/c");
        Assert.assertTrue((boolean)klass.isInstance(retrievedDataSourceObject), (String)(klass + " is not an instance of " + retrievedDataSourceObject));
        return (T)retrievedDataSourceObject;
    }
}

