/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.platform.jndi;

import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import net.sf.log4jdbc.sql.jdbcapi.DataSourceSpy;
import org.killbill.billing.platform.jndi.DataSourceProxy;
import org.killbill.billing.platform.jndi.ReferenceableDataSourceSpyFactory;

public class ReferenceableDataSourceSpy
extends DataSourceSpy
implements Referenceable {
    private final DataSource dataSource;
    private final String dataSourceId;

    public ReferenceableDataSourceSpy(String dataSourceId) {
        super(DataSourceProxy.getDelegate(dataSourceId));
        this.dataSource = DataSourceProxy.getDelegate(dataSourceId);
        this.dataSourceId = dataSourceId;
    }

    public ReferenceableDataSourceSpy(DataSource realDataSource, String dataSourceId) {
        super(realDataSource);
        this.dataSource = realDataSource;
        this.dataSourceId = dataSourceId;
        DataSourceProxy.addDelegate(dataSourceId, realDataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(DataSourceProxy.class.getName(), ReferenceableDataSourceSpyFactory.class.getName(), null);
        reference.add(new StringRefAddr("dataSourceId", this.dataSourceId));
        return reference;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("javax.sql.DataSource.getParentLogger() is not currently supported by " + this.getClass().getName());
    }
}

