/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.wrapper;

import com.google.inject.Inject;
import java.util.UUID;
import org.joda.time.Period;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.applicator.OverdueStateApplicator;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.calculator.BillingStateCalculator;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueState;
import org.killbill.billing.overdue.config.DefaultOverdueStateSet;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.overdue.config.api.OverdueStateSet;
import org.killbill.billing.overdue.wrapper.OverdueWrapper;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.clock.Clock;
import org.killbill.commons.locker.GlobalLocker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueWrapperFactory {
    private static final Logger log = LoggerFactory.getLogger(OverdueWrapperFactory.class);
    private final AccountInternalApi accountApi;
    private final BillingStateCalculator billingStateCalculator;
    private final OverdueStateApplicator overdueStateApplicator;
    private final BlockingInternalApi api;
    private final GlobalLocker locker;
    private final Clock clock;
    private final OverdueConfigCache overdueConfigCache;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public OverdueWrapperFactory(BlockingInternalApi api, GlobalLocker locker, Clock clock, BillingStateCalculator billingStateCalculator, OverdueStateApplicator overdueStateApplicatorBundle, OverdueConfigCache overdueConfigCache, AccountInternalApi accountApi, InternalCallContextFactory internalCallContextFactory) {
        this.billingStateCalculator = billingStateCalculator;
        this.overdueStateApplicator = overdueStateApplicatorBundle;
        this.accountApi = accountApi;
        this.api = api;
        this.locker = locker;
        this.clock = clock;
        this.overdueConfigCache = overdueConfigCache;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public OverdueWrapper createOverdueWrapperFor(Account blockable, InternalTenantContext context) throws OverdueException {
        return new OverdueWrapper(blockable, this.api, this.getOverdueStateSet(context), this.locker, this.clock, this.billingStateCalculator, this.overdueStateApplicator, this.internalCallContextFactory);
    }

    public OverdueWrapper createOverdueWrapperFor(UUID id, InternalTenantContext context) throws OverdueException {
        try {
            Account account = this.accountApi.getAccountById(id, context);
            return new OverdueWrapper(account, this.api, this.getOverdueStateSet(context), this.locker, this.clock, this.billingStateCalculator, this.overdueStateApplicator, this.internalCallContextFactory);
        }
        catch (AccountApiException e) {
            throw new OverdueException((BillingExceptionBase)e);
        }
    }

    private OverdueStateSet getOverdueStateSet(InternalTenantContext context) throws OverdueException {
        try {
            OverdueConfig overdueConfig = this.overdueConfigCache.getOverdueConfig(context);
            if (overdueConfig == null || overdueConfig.getOverdueStatesAccount() == null) {
                return new DefaultOverdueStateSet(){

                    @Override
                    public DefaultOverdueState[] getStates() {
                        return new DefaultOverdueState[0];
                    }

                    public Period getInitialReevaluationInterval() {
                        return null;
                    }
                };
            }
            return ((DefaultOverdueConfig)overdueConfig).getOverdueStatesAccount();
        }
        catch (OverdueApiException e) {
            throw new OverdueException((BillingExceptionBase)e);
        }
    }
}

