/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.service;

import com.google.inject.Inject;
import javax.inject.Named;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.overdue.OverdueProperties;
import org.killbill.billing.overdue.OverdueService;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.listener.OverdueListener;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.bus.api.PersistentBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOverdueService
implements OverdueService {
    private static final Logger log = LoggerFactory.getLogger(DefaultOverdueService.class);
    private final OverdueProperties properties;
    private final OverdueNotifier asyncNotifier;
    private final OverdueNotifier checkNotifier;
    private final BusService busService;
    private final OverdueListener listener;
    private final OverdueConfigCache overdueConfigCache;
    private final TenantInternalApi.CacheInvalidationCallback overdueCacheInvalidationCallback;
    private final TenantInternalApi tenantInternalApi;
    private boolean isConfigLoaded;

    @Inject
    public DefaultOverdueService(OverdueProperties properties, @Named(value="overdueNotifierCheck") OverdueNotifier checkNotifier, @Named(value="overdueNotifierAsyncBus") OverdueNotifier asyncNotifier, BusService busService, OverdueListener listener, OverdueConfigCache overdueConfigCache, @Named(value="overdueInvalidationCallback") TenantInternalApi.CacheInvalidationCallback overdueCacheInvalidationCallback, TenantInternalApi tenantInternalApi) {
        this.properties = properties;
        this.checkNotifier = checkNotifier;
        this.asyncNotifier = asyncNotifier;
        this.busService = busService;
        this.listener = listener;
        this.isConfigLoaded = false;
        this.overdueConfigCache = overdueConfigCache;
        this.overdueCacheInvalidationCallback = overdueCacheInvalidationCallback;
        this.tenantInternalApi = tenantInternalApi;
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.OVERDUE_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.OVERDUE_SERVICE.getRegistrationOrdering();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.LOAD_CATALOG)
    public synchronized void loadConfig() throws KillbillService.ServiceException {
        if (!this.isConfigLoaded) {
            try {
                this.overdueConfigCache.loadDefaultOverdueConfig(this.properties.getConfigURI());
                this.isConfigLoaded = true;
            }
            catch (OverdueApiException e) {
                log.warn("Overdue system disabled: unable to load the overdue config from uri='{}'", (Object)this.properties.getConfigURI(), (Object)e);
            }
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public void initialize() {
        this.registerForBus();
        this.checkNotifier.initialize();
        this.asyncNotifier.initialize();
        this.tenantInternalApi.initializeCacheInvalidationCallback(TenantKV.TenantKey.OVERDUE_CONFIG, this.overdueCacheInvalidationCallback);
    }

    private void registerForBus() {
        try {
            this.busService.getBus().register((Object)this.listener);
        }
        catch (PersistentBus.EventBusException e) {
            log.error("Failed to register OverdueListener", (Throwable)e);
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
    public void start() {
        this.checkNotifier.start();
        this.asyncNotifier.start();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() {
        try {
            this.busService.getBus().unregister((Object)this.listener);
        }
        catch (PersistentBus.EventBusException e) {
            log.error("Failed to unregister OverdueListener", (Throwable)e);
        }
        this.checkNotifier.stop();
        this.asyncNotifier.stop();
    }

    public OverdueConfig getOverdueConfig(InternalTenantContext internalTenantContext) throws OverdueApiException {
        return this.overdueConfigCache.getOverdueConfig(internalTenantContext);
    }
}

