/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import com.google.inject.Inject;
import java.util.Iterator;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.overdue.notification.DefaultOverduePosterBase;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.jdbi.v2.IDBI;

public class OverdueCheckPoster
extends DefaultOverduePosterBase {
    @Inject
    public OverdueCheckPoster(NotificationQueueService notificationQueueService, IDBI dbi, @Named(value="main-ro") IDBI roDbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        super(notificationQueueService, dbi, roDbi, clock, cacheControllerDispatcher, nonEntityDao, internalCallContextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends OverdueCheckNotificationKey> boolean cleanupFutureNotificationsFormTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, Iterable<NotificationEventWithMetadata<T>> futureNotifications, DateTime futureNotificationTime, NotificationQueue overdueQueue) {
        boolean shouldInsertNewNotification = true;
        int minIndexToDeleteFrom = 0;
        int index = 0;
        Iterator<NotificationEventWithMetadata<T>> iterator = futureNotifications.iterator();
        try {
            while (iterator.hasNext()) {
                NotificationEventWithMetadata<T> cur = iterator.next();
                if (index == 0) {
                    if (cur.getEffectiveDate().isBefore((ReadableInstant)futureNotificationTime)) {
                        minIndexToDeleteFrom = 1;
                        shouldInsertNewNotification = false;
                    } else {
                        minIndexToDeleteFrom = 0;
                    }
                }
                if (minIndexToDeleteFrom <= index) {
                    overdueQueue.removeNotificationFromTransaction(entitySqlDaoWrapperFactory.getHandle().getConnection(), cur.getRecordId());
                }
                ++index;
            }
        }
        finally {
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        return shouldInsertNewNotification;
    }
}

