/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.UUID;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.overdue.notification.OverduePoster;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import org.killbill.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultOverduePosterBase
implements OverduePoster {
    private static final Logger log = LoggerFactory.getLogger(DefaultOverduePosterBase.class);
    private final NotificationQueueService notificationQueueService;
    private final EntitySqlDaoTransactionalJdbiWrapper transactionalSqlDao;

    public DefaultOverduePosterBase(NotificationQueueService notificationQueueService, IDBI dbi, @Named(value="main-ro") IDBI roDbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao, InternalCallContextFactory internalCallContextFactory) {
        this.notificationQueueService = notificationQueueService;
        this.transactionalSqlDao = new EntitySqlDaoTransactionalJdbiWrapper(dbi, roDbi, clock, cacheControllerDispatcher, nonEntityDao, internalCallContextFactory);
    }

    @Override
    public <T extends OverdueCheckNotificationKey> void insertOverdueNotification(final UUID accountId, final DateTime futureNotificationTime, String overdueQueueName, final T notificationKey, final InternalCallContext context) {
        try {
            final NotificationQueue overdueQueue = this.notificationQueueService.getNotificationQueue("overdue-service", overdueQueueName);
            this.transactionalSqlDao.execute(false, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

                public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                    Class<?> clazz = ((Object)((Object)notificationKey)).getClass();
                    Iterable futureNotifications = DefaultOverduePosterBase.this.getFutureNotificationsForAccountInTransaction(entitySqlDaoWrapperFactory, overdueQueue, clazz, context);
                    boolean shouldInsertNewNotification = DefaultOverduePosterBase.this.cleanupFutureNotificationsFormTransaction(entitySqlDaoWrapperFactory, futureNotifications, futureNotificationTime, overdueQueue);
                    if (shouldInsertNewNotification) {
                        log.debug("Queuing overdue check notification. Account id: {}, timestamp: {}", (Object)accountId.toString(), (Object)futureNotificationTime.toString());
                        overdueQueue.recordFutureNotificationFromTransaction(entitySqlDaoWrapperFactory.getHandle().getConnection(), futureNotificationTime, (NotificationEvent)notificationKey, context.getUserToken(), context.getAccountRecordId(), context.getTenantRecordId());
                    } else {
                        log.debug("Skipping queuing overdue check notification. Account id: {}, timestamp: {}", (Object)accountId.toString(), (Object)futureNotificationTime.toString());
                    }
                    return null;
                }
            });
        }
        catch (NotificationQueueService.NoSuchNotificationQueue e) {
            log.error("Attempting to put items on a non-existent queue (DefaultOverdueCheck).", (Throwable)e);
        }
    }

    @Override
    public <T extends OverdueCheckNotificationKey> void clearOverdueCheckNotifications(UUID accountId, String overdueQueueName, final Class<T> clazz, final InternalCallContext context) {
        try {
            final NotificationQueue checkOverdueQueue = this.notificationQueueService.getNotificationQueue("overdue-service", overdueQueueName);
            this.transactionalSqlDao.execute(false, (EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void inTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory) throws Exception {
                    Iterable futureNotifications = DefaultOverduePosterBase.this.getFutureNotificationsForAccountInTransaction(entitySqlDaoWrapperFactory, checkOverdueQueue, clazz, context);
                    Iterator iterator = futureNotifications.iterator();
                    try {
                        while (iterator.hasNext()) {
                            NotificationEventWithMetadata notification = iterator.next();
                            checkOverdueQueue.removeNotificationFromTransaction(entitySqlDaoWrapperFactory.getHandle().getConnection(), notification.getRecordId());
                        }
                    }
                    finally {
                        while (iterator.hasNext()) {
                            iterator.next();
                        }
                    }
                    return null;
                }
            });
        }
        catch (NotificationQueueService.NoSuchNotificationQueue e) {
            log.error("Attempting to clear items from a non-existent queue (DefaultOverdueCheck).", (Throwable)e);
        }
    }

    @VisibleForTesting
    <T extends OverdueCheckNotificationKey> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationsForAccountInTransaction(EntitySqlDaoWrapperFactory entitySqlDaoWrapperFactory, NotificationQueue checkOverdueQueue, Class<T> clazz, InternalCallContext context) {
        return checkOverdueQueue.getFutureNotificationFromTransactionForSearchKeys(context.getAccountRecordId(), context.getTenantRecordId(), entitySqlDaoWrapperFactory.getHandle().getConnection());
    }

    protected abstract <T extends OverdueCheckNotificationKey> boolean cleanupFutureNotificationsFormTransaction(EntitySqlDaoWrapperFactory var1, Iterable<NotificationEventWithMetadata<T>> var2, DateTime var3, NotificationQueue var4);
}

