/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.overdue.OverdueProperties;
import org.killbill.billing.overdue.listener.OverdueDispatcher;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultOverdueNotifierBase
implements OverdueNotifier {
    private static final Logger log = LoggerFactory.getLogger(DefaultOverdueNotifierBase.class);
    private final InternalCallContextFactory internalCallContextFactory;
    protected final NotificationQueueService notificationQueueService;
    protected final OverdueProperties config;
    protected final OverdueDispatcher dispatcher;
    protected NotificationQueue overdueQueue;

    public abstract String getQueueName();

    @Override
    public abstract void handleReadyNotification(NotificationEvent var1, DateTime var2, UUID var3, Long var4, Long var5);

    public DefaultOverdueNotifierBase(NotificationQueueService notificationQueueService, OverdueProperties config, InternalCallContextFactory internalCallContextFactory, OverdueDispatcher dispatcher) {
        this.notificationQueueService = notificationQueueService;
        this.config = config;
        this.dispatcher = dispatcher;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    @Override
    public void initialize() {
        final DefaultOverdueNotifierBase myself = this;
        NotificationQueueService.NotificationQueueHandler notificationQueueHandler = new NotificationQueueService.NotificationQueueHandler(){

            public void handleReadyNotification(NotificationEvent notificationKey, DateTime eventDate, UUID userToken, Long accountRecordId, Long tenantRecordId) {
                myself.handleReadyNotification(notificationKey, eventDate, userToken, accountRecordId, tenantRecordId);
            }
        };
        try {
            this.overdueQueue = this.notificationQueueService.createNotificationQueue("overdue-service", this.getQueueName(), notificationQueueHandler);
        }
        catch (NotificationQueueService.NotificationQueueAlreadyExists e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() {
        this.overdueQueue.startQueue();
    }

    @Override
    public void stop() {
        if (this.overdueQueue != null) {
            this.overdueQueue.stopQueue();
            try {
                this.notificationQueueService.deleteNotificationQueue(this.overdueQueue.getServiceName(), this.overdueQueue.getQueueName());
            }
            catch (NotificationQueueService.NoSuchNotificationQueue e) {
                log.error("Error deleting a queue by its own name - this should never happen", (Throwable)e);
            }
        }
    }

    protected InternalCallContext createCallContext(UUID userToken, Long accountRecordId, Long tenantRecordId) {
        return this.internalCallContextFactory.createInternalCallContext(tenantRecordId, accountRecordId, "OverdueService", CallOrigin.INTERNAL, UserType.SYSTEM, userToken);
    }
}

