/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.listener;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.List;
import java.util.UUID;
import javax.inject.Named;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.events.ControlTagCreationInternalEvent;
import org.killbill.billing.events.ControlTagDeletionInternalEvent;
import org.killbill.billing.events.InvoiceAdjustmentInternalEvent;
import org.killbill.billing.events.InvoiceCreationInternalEvent;
import org.killbill.billing.events.InvoicePaymentErrorInternalEvent;
import org.killbill.billing.events.InvoicePaymentInfoInternalEvent;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.DefaultOverdueState;
import org.killbill.billing.overdue.notification.OverdueAsyncBusNotificationKey;
import org.killbill.billing.overdue.notification.OverduePoster;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.bus.api.BusEvent;
import org.killbill.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverdueListener {
    private static final Logger log = LoggerFactory.getLogger(OverdueListener.class);
    private final InternalCallContextFactory internalCallContextFactory;
    private final CacheController<String, UUID> objectIdCacheController;
    private final Clock clock;
    private final OverduePoster asyncPoster;
    private final OverdueConfigCache overdueConfigCache;
    private final NonEntityDao nonEntityDao;
    private final AccountInternalApi accountApi;

    @Inject
    public OverdueListener(NonEntityDao nonEntityDao, CacheControllerDispatcher cacheControllerDispatcher, Clock clock, @Named(value="overdueNotifierAsyncBus") OverduePoster asyncPoster, OverdueConfigCache overdueConfigCache, InternalCallContextFactory internalCallContextFactory, AccountInternalApi accountApi) {
        this.nonEntityDao = nonEntityDao;
        this.clock = clock;
        this.asyncPoster = asyncPoster;
        this.overdueConfigCache = overdueConfigCache;
        this.objectIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OBJECT_ID);
        this.internalCallContextFactory = internalCallContextFactory;
        this.accountApi = accountApi;
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleTagInsert(ControlTagCreationInternalEvent event) {
        if (event.getTagDefinition().getName().equals(ControlTagType.OVERDUE_ENFORCEMENT_OFF.toString()) && event.getObjectType() == ObjectType.ACCOUNT) {
            InternalCallContext internalCallContext = this.createCallContext(event.getUserToken(), event.getSearchKey1(), event.getSearchKey2());
            this.insertBusEventIntoNotificationQueue(event.getObjectId(), OverdueAsyncBusNotificationKey.OverdueAsyncBusNotificationAction.CLEAR, internalCallContext);
        } else if (event.getTagDefinition().getName().equals(ControlTagType.WRITTEN_OFF.toString()) && event.getObjectType() == ObjectType.INVOICE) {
            UUID accountId = this.nonEntityDao.retrieveIdFromObject(event.getSearchKey1(), ObjectType.ACCOUNT, this.objectIdCacheController);
            this.insertBusEventIntoNotificationQueue(accountId, (BusEvent)event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleTagRemoval(ControlTagDeletionInternalEvent event) {
        if (event.getTagDefinition().getName().equals(ControlTagType.OVERDUE_ENFORCEMENT_OFF.toString()) && event.getObjectType() == ObjectType.ACCOUNT) {
            this.insertBusEventIntoNotificationQueue(event.getObjectId(), (BusEvent)event);
        } else if (event.getTagDefinition().getName().equals(ControlTagType.WRITTEN_OFF.toString()) && event.getObjectType() == ObjectType.INVOICE) {
            UUID accountId = this.nonEntityDao.retrieveIdFromObject(event.getSearchKey1(), ObjectType.ACCOUNT, this.objectIdCacheController);
            this.insertBusEventIntoNotificationQueue(accountId, (BusEvent)event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handlePaymentInfoEvent(InvoicePaymentInfoInternalEvent event) {
        log.debug("Received InvoicePaymentInfo event {}", (Object)event);
        this.insertBusEventIntoNotificationQueue(event.getAccountId(), (BusEvent)event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handlePaymentErrorEvent(InvoicePaymentErrorInternalEvent event) {
        log.debug("Received InvoicePaymentError event {}", (Object)event);
        this.insertBusEventIntoNotificationQueue(event.getAccountId(), (BusEvent)event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleInvoiceAdjustmentEvent(InvoiceAdjustmentInternalEvent event) {
        log.debug("Received InvoiceAdjustment event {}", (Object)event);
        this.insertBusEventIntoNotificationQueue(event.getAccountId(), (BusEvent)event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handleInvoiceCreation(InvoiceCreationInternalEvent event) {
        log.debug("Received InvoiceCreation event {}", (Object)event);
        this.insertBusEventIntoNotificationQueue(event.getAccountId(), (BusEvent)event);
    }

    private void insertBusEventIntoNotificationQueue(UUID accountId, BusEvent event) {
        InternalCallContext internalCallContext = this.createCallContext(event.getUserToken(), event.getSearchKey1(), event.getSearchKey2());
        this.insertBusEventIntoNotificationQueue(accountId, OverdueAsyncBusNotificationKey.OverdueAsyncBusNotificationAction.REFRESH, internalCallContext);
    }

    private InternalCallContext createCallContext(UUID userToken, Long accountRecordId, Long tenantRecordId) {
        return this.internalCallContextFactory.createInternalCallContext(tenantRecordId, accountRecordId, "OverdueService", CallOrigin.INTERNAL, UserType.SYSTEM, userToken);
    }

    private void insertBusEventIntoNotificationQueue(UUID accountId, OverdueAsyncBusNotificationKey.OverdueAsyncBusNotificationAction action, InternalCallContext callContext) {
        boolean shouldInsertNotification = this.shouldInsertNotification((InternalTenantContext)callContext);
        if (!shouldInsertNotification) {
            log.debug("OverdueListener: shouldInsertNotification=false");
            return;
        }
        OverdueAsyncBusNotificationKey notificationKey = new OverdueAsyncBusNotificationKey(accountId, action);
        this.asyncPoster.insertOverdueNotification(accountId, callContext.getCreatedDate(), "overdue-async-bus-queue", notificationKey, callContext);
        try {
            List childrenAccounts;
            Account account = this.accountApi.getAccountById(accountId, (InternalTenantContext)callContext);
            if (account.getParentAccountId() != null && account.isPaymentDelegatedToParent().booleanValue()) {
                InternalTenantContext parentAccountInternalTenantContext = this.internalCallContextFactory.createInternalTenantContext(account.getParentAccountId(), (InternalTenantContext)callContext);
                InternalCallContext parentAccountContext = this.internalCallContextFactory.createInternalCallContext(parentAccountInternalTenantContext.getAccountRecordId(), callContext);
                notificationKey = new OverdueAsyncBusNotificationKey(account.getParentAccountId(), action);
                this.asyncPoster.insertOverdueNotification(account.getParentAccountId(), callContext.getCreatedDate(), "overdue-async-bus-queue", notificationKey, parentAccountContext);
            }
            if ((childrenAccounts = this.accountApi.getChildrenAccounts(accountId, callContext)) != null) {
                for (Account childAccount : childrenAccounts) {
                    if (!childAccount.isPaymentDelegatedToParent().booleanValue()) continue;
                    InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContext(childAccount.getId(), (InternalTenantContext)callContext);
                    InternalCallContext accountContext = this.internalCallContextFactory.createInternalCallContext(internalTenantContext.getAccountRecordId(), callContext);
                    notificationKey = new OverdueAsyncBusNotificationKey(childAccount.getId(), action);
                    this.asyncPoster.insertOverdueNotification(childAccount.getId(), callContext.getCreatedDate(), "overdue-async-bus-queue", notificationKey, accountContext);
                }
            }
        }
        catch (Exception e) {
            log.error("Error loading child accounts from accountId='{}'", (Object)accountId);
        }
    }

    private boolean shouldInsertNotification(InternalTenantContext internalTenantContext) {
        OverdueConfig overdueConfig;
        try {
            overdueConfig = this.overdueConfigCache.getOverdueConfig(internalTenantContext);
        }
        catch (OverdueApiException e) {
            log.warn("Failed to extract overdue config for tenantRecordId='{}'", (Object)internalTenantContext.getTenantRecordId());
            overdueConfig = null;
        }
        if (overdueConfig == null || overdueConfig.getOverdueStatesAccount() == null || overdueConfig.getOverdueStatesAccount().getStates() == null) {
            return false;
        }
        for (DefaultOverdueState state : ((DefaultOverdueConfig)overdueConfig).getOverdueStatesAccount().getStates()) {
            if (state.getConditionEvaluation() == null) continue;
            return true;
        }
        return false;
    }
}

