/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import org.joda.time.Period;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.overdue.api.OverdueStatesAccount;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultOverdueState;
import org.killbill.billing.overdue.config.DefaultOverdueStateSet;

public class DefaultOverdueStatesAccount
extends DefaultOverdueStateSet
implements OverdueStatesAccount,
Externalizable {
    @XmlElement(required=false, name="initialReevaluationInterval")
    private DefaultDuration initialReevaluationInterval;
    @XmlElement(required=true, name="state")
    private DefaultOverdueState[] accountOverdueStates = new DefaultOverdueState[0];

    @Override
    public DefaultOverdueState[] getStates() {
        return this.accountOverdueStates;
    }

    public Period getInitialReevaluationInterval() {
        if (this.initialReevaluationInterval == null || this.initialReevaluationInterval.getUnit() == TimeUnit.UNLIMITED || this.initialReevaluationInterval.getNumber() == 0) {
            return null;
        }
        return this.initialReevaluationInterval.toJodaPeriod();
    }

    public DefaultOverdueStatesAccount setAccountOverdueStates(DefaultOverdueState[] accountOverdueStates) {
        this.accountOverdueStates = accountOverdueStates;
        return this;
    }

    public DefaultOverdueStatesAccount setInitialReevaluationInterval(DefaultDuration initialReevaluationInterval) {
        this.initialReevaluationInterval = initialReevaluationInterval;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOverdueStatesAccount that = (DefaultOverdueStatesAccount)o;
        if (this.initialReevaluationInterval != null ? !this.initialReevaluationInterval.equals(that.initialReevaluationInterval) : that.initialReevaluationInterval != null) {
            return false;
        }
        return Arrays.equals(this.accountOverdueStates, that.accountOverdueStates);
    }

    public int hashCode() {
        int result = this.initialReevaluationInterval != null ? this.initialReevaluationInterval.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.accountOverdueStates);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initialReevaluationInterval);
        out.writeObject(this.accountOverdueStates);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initialReevaluationInterval = (DefaultDuration)in.readObject();
        this.accountOverdueStates = (DefaultOverdueState[])in.readObject();
    }
}

