/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.overdue.ConditionEvaluation;
import org.killbill.billing.overdue.api.OverdueApiException;
import org.killbill.billing.overdue.api.OverdueCancellationPolicy;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultEmailNotification;
import org.killbill.billing.overdue.config.DefaultOverdueCondition;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultOverdueState
extends ValidatingConfig<DefaultOverdueConfig>
implements OverdueState,
Externalizable {
    private static final int MAX_NAME_LENGTH = 50;
    @XmlElement(required=false, name="condition")
    private DefaultOverdueCondition condition;
    @XmlAttribute(required=true, name="name")
    @XmlID
    private String name;
    @XmlElement(required=false, name="externalMessage")
    private String externalMessage = "";
    @XmlElement(required=false, name="blockChanges")
    private Boolean blockChanges = false;
    @XmlElement(required=false, name="disableEntitlementAndChangesBlocked")
    private Boolean disableEntitlement = false;
    @XmlElement(required=false, name="subscriptionCancellationPolicy")
    private OverdueCancellationPolicy subscriptionCancellationPolicy = OverdueCancellationPolicy.NONE;
    @XmlElement(required=false, name="isClearState")
    private Boolean isClearState = false;
    @XmlElement(required=false, name="autoReevaluationInterval")
    private DefaultDuration autoReevaluationInterval;
    @Deprecated
    @XmlElement(required=false, name="enterStateEmailNotification")
    private DefaultEmailNotification enterStateEmailNotification;

    public ConditionEvaluation getConditionEvaluation() {
        return this.condition;
    }

    public OverdueCondition getOverdueCondition() {
        return this.condition;
    }

    public String getName() {
        return this.name;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public boolean isBlockChanges() {
        return this.blockChanges;
    }

    public boolean isDisableEntitlementAndChangesBlocked() {
        return this.disableEntitlement;
    }

    public OverdueCancellationPolicy getOverdueCancellationPolicy() {
        return this.subscriptionCancellationPolicy;
    }

    public Duration getAutoReevaluationInterval() throws OverdueApiException {
        if (this.autoReevaluationInterval == null || this.autoReevaluationInterval.getUnit() == TimeUnit.UNLIMITED || this.autoReevaluationInterval.getNumber() == 0) {
            throw new OverdueApiException(ErrorCode.OVERDUE_NO_REEVALUATION_INTERVAL, new Object[]{this.name});
        }
        return this.autoReevaluationInterval;
    }

    public void setAutoReevaluationInterval(DefaultDuration autoReevaluationInterval) {
        this.autoReevaluationInterval = autoReevaluationInterval;
    }

    public DefaultOverdueState setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultOverdueState setClearState(boolean isClearState) {
        this.isClearState = isClearState;
        return this;
    }

    public DefaultOverdueState setExternalMessage(String externalMessage) {
        this.externalMessage = externalMessage;
        return this;
    }

    public DefaultOverdueState setDisableEntitlement(boolean cancel) {
        this.disableEntitlement = cancel;
        return this;
    }

    public DefaultOverdueState setSubscriptionCancellationPolicy(OverdueCancellationPolicy policy) {
        this.subscriptionCancellationPolicy = policy;
        return this;
    }

    public DefaultOverdueState setBlockChanges(boolean cancel) {
        this.blockChanges = cancel;
        return this;
    }

    public DefaultOverdueState setCondition(DefaultOverdueCondition condition) {
        this.condition = condition;
        return this;
    }

    public boolean isClearState() {
        return this.isClearState;
    }

    public ValidationErrors validate(DefaultOverdueConfig root, ValidationErrors errors) {
        if (this.name.length() > 50) {
            errors.add((Object)new ValidationError(String.format("Name of state '%s' exceeds the maximum length of %d", this.name, 50), DefaultOverdueState.class, this.name));
        }
        return errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOverdueState that = (DefaultOverdueState)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.externalMessage != null ? !this.externalMessage.equals(that.externalMessage) : that.externalMessage != null) {
            return false;
        }
        if (this.blockChanges != null ? !this.blockChanges.equals(that.blockChanges) : that.blockChanges != null) {
            return false;
        }
        if (this.disableEntitlement != null ? !this.disableEntitlement.equals(that.disableEntitlement) : that.disableEntitlement != null) {
            return false;
        }
        if (this.subscriptionCancellationPolicy != that.subscriptionCancellationPolicy) {
            return false;
        }
        if (this.isClearState != null ? !this.isClearState.equals(that.isClearState) : that.isClearState != null) {
            return false;
        }
        if (this.autoReevaluationInterval != null ? !this.autoReevaluationInterval.equals(that.autoReevaluationInterval) : that.autoReevaluationInterval != null) {
            return false;
        }
        return this.enterStateEmailNotification != null ? this.enterStateEmailNotification.equals(that.enterStateEmailNotification) : that.enterStateEmailNotification == null;
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.externalMessage != null ? this.externalMessage.hashCode() : 0);
        result = 31 * result + (this.blockChanges != null ? this.blockChanges.hashCode() : 0);
        result = 31 * result + (this.disableEntitlement != null ? this.disableEntitlement.hashCode() : 0);
        result = 31 * result + (this.subscriptionCancellationPolicy != null ? this.subscriptionCancellationPolicy.hashCode() : 0);
        result = 31 * result + (this.isClearState != null ? this.isClearState.hashCode() : 0);
        result = 31 * result + (this.autoReevaluationInterval != null ? this.autoReevaluationInterval.hashCode() : 0);
        result = 31 * result + (this.enterStateEmailNotification != null ? this.enterStateEmailNotification.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultOverdueState{");
        sb.append("condition=").append(this.condition);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", externalMessage='").append(this.externalMessage).append('\'');
        sb.append(", blockChanges=").append(this.blockChanges);
        sb.append(", disableEntitlement=").append(this.disableEntitlement);
        sb.append(", subscriptionCancellationPolicy=").append(this.subscriptionCancellationPolicy);
        sb.append(", isClearState=").append(this.isClearState);
        sb.append(", autoReevaluationInterval=").append(this.autoReevaluationInterval);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.condition);
        out.writeUTF(this.name);
        out.writeUTF(this.externalMessage);
        out.writeBoolean(this.blockChanges);
        out.writeBoolean(this.disableEntitlement);
        out.writeBoolean(this.subscriptionCancellationPolicy != null);
        if (this.subscriptionCancellationPolicy != null) {
            out.writeUTF(this.subscriptionCancellationPolicy.name());
        }
        out.writeBoolean(this.isClearState);
        out.writeObject(this.autoReevaluationInterval);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.condition = (DefaultOverdueCondition)in.readObject();
        this.name = in.readUTF();
        this.externalMessage = in.readUTF();
        this.blockChanges = in.readBoolean();
        this.disableEntitlement = in.readBoolean();
        this.subscriptionCancellationPolicy = in.readBoolean() ? OverdueCancellationPolicy.valueOf((String)in.readUTF()) : null;
        this.isClearState = in.readBoolean();
        this.autoReevaluationInterval = (DefaultDuration)in.readObject();
    }
}

