/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.config;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.overdue.ConditionEvaluation;
import org.killbill.billing.overdue.api.OverdueCondition;
import org.killbill.billing.overdue.config.DefaultDuration;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.util.tag.ControlTagType;
import org.killbill.billing.util.tag.Tag;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultOverdueCondition
extends ValidatingConfig<DefaultOverdueConfig>
implements ConditionEvaluation,
OverdueCondition,
Externalizable {
    @XmlElement(required=false, name="numberOfUnpaidInvoicesEqualsOrExceeds")
    private Integer numberOfUnpaidInvoicesEqualsOrExceeds;
    @XmlElement(required=false, name="totalUnpaidInvoiceBalanceEqualsOrExceeds")
    private BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds;
    @XmlElement(required=false, name="timeSinceEarliestUnpaidInvoiceEqualsOrExceeds")
    private DefaultDuration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    @XmlElementWrapper(required=false, name="responseForLastFailedPaymentIn")
    @XmlElement(required=false, name="response")
    private PaymentResponse[] responseForLastFailedPayment;
    @XmlElement(required=false, name="controlTagInclusion")
    private ControlTagType controlTagInclusion;
    @XmlElement(required=false, name="controlTagExclusion")
    private ControlTagType controlTagExclusion;

    public boolean evaluate(BillingState state, LocalDate date) {
        LocalDate unpaidInvoiceTriggerDate = null;
        if (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null && state.getDateOfEarliestUnpaidInvoice() != null) {
            unpaidInvoiceTriggerDate = state.getDateOfEarliestUnpaidInvoice().plus((ReadablePeriod)this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.toJodaPeriod());
        }
        return !(this.numberOfUnpaidInvoicesEqualsOrExceeds != null && state.getNumberOfUnpaidInvoices() < this.numberOfUnpaidInvoicesEqualsOrExceeds || this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null && this.totalUnpaidInvoiceBalanceEqualsOrExceeds.compareTo(state.getBalanceOfUnpaidInvoices()) > 0 || this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null && (unpaidInvoiceTriggerDate == null || unpaidInvoiceTriggerDate.isAfter((ReadablePartial)date)) || this.responseForLastFailedPayment != null && !this.responseIsIn(state.getResponseForLastFailedPayment(), this.responseForLastFailedPayment) || this.controlTagInclusion != null && !this.isTagIn(this.controlTagInclusion, state.getTags()) || this.controlTagExclusion != null && !this.isTagNotIn(this.controlTagExclusion, state.getTags()));
    }

    private boolean responseIsIn(PaymentResponse actualResponse, PaymentResponse[] responseForLastFailedPayment) {
        for (PaymentResponse response : responseForLastFailedPayment) {
            if (!response.equals((Object)actualResponse)) continue;
            return true;
        }
        return false;
    }

    private boolean isTagIn(ControlTagType tagType, Tag[] tags) {
        for (Tag t : tags) {
            if (!t.getTagDefinitionId().equals(tagType.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isTagNotIn(ControlTagType tagType, Tag[] tags) {
        for (Tag t : tags) {
            if (!t.getTagDefinitionId().equals(tagType.getId())) continue;
            return false;
        }
        return true;
    }

    public ValidationErrors validate(DefaultOverdueConfig root, ValidationErrors errors) {
        return errors;
    }

    public Integer getNumberOfUnpaidInvoicesEqualsOrExceeds() {
        return this.numberOfUnpaidInvoicesEqualsOrExceeds;
    }

    public BigDecimal getTotalUnpaidInvoiceBalanceEqualsOrExceeds() {
        return this.totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public Duration getTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds() {
        return this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    }

    public PaymentResponse[] getResponseForLastFailedPaymentIn() {
        return this.responseForLastFailedPayment;
    }

    public ControlTagType getInclusionControlTagType() {
        return this.controlTagInclusion;
    }

    public ControlTagType getExclusionControlTagType() {
        return this.controlTagExclusion;
    }

    public void setNumberOfUnpaidInvoicesEqualsOrExceeds(Integer numberOfUnpaidInvoicesEqualsOrExceeds) {
        this.numberOfUnpaidInvoicesEqualsOrExceeds = numberOfUnpaidInvoicesEqualsOrExceeds;
    }

    public void setTotalUnpaidInvoiceBalanceEqualsOrExceeds(BigDecimal totalUnpaidInvoiceBalanceEqualsOrExceeds) {
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = totalUnpaidInvoiceBalanceEqualsOrExceeds;
    }

    public void setTimeSinceEarliestUnpaidInvoiceEqualsOrExceeds(DefaultDuration timeSinceEarliestUnpaidInvoiceEqualsOrExceeds) {
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = timeSinceEarliestUnpaidInvoiceEqualsOrExceeds;
    }

    public void setResponseForLastFailedPayment(PaymentResponse[] responseForLastFailedPayment) {
        this.responseForLastFailedPayment = responseForLastFailedPayment;
    }

    public void setControlTagInclusion(ControlTagType controlTagInclusion) {
        this.controlTagInclusion = controlTagInclusion;
    }

    public void setControlTagExclusion(ControlTagType controlTagExclusion) {
        this.controlTagExclusion = controlTagExclusion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOverdueCondition that = (DefaultOverdueCondition)o;
        if (this.numberOfUnpaidInvoicesEqualsOrExceeds != null ? !this.numberOfUnpaidInvoicesEqualsOrExceeds.equals(that.numberOfUnpaidInvoicesEqualsOrExceeds) : that.numberOfUnpaidInvoicesEqualsOrExceeds != null) {
            return false;
        }
        if (this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null ? !this.totalUnpaidInvoiceBalanceEqualsOrExceeds.equals(that.totalUnpaidInvoiceBalanceEqualsOrExceeds) : that.totalUnpaidInvoiceBalanceEqualsOrExceeds != null) {
            return false;
        }
        if (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null ? !this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.equals(that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds) : that.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null) {
            return false;
        }
        if (!Arrays.equals(this.responseForLastFailedPayment, that.responseForLastFailedPayment)) {
            return false;
        }
        if (this.controlTagInclusion != that.controlTagInclusion) {
            return false;
        }
        return this.controlTagExclusion == that.controlTagExclusion;
    }

    public int hashCode() {
        int result = this.numberOfUnpaidInvoicesEqualsOrExceeds != null ? this.numberOfUnpaidInvoicesEqualsOrExceeds.hashCode() : 0;
        result = 31 * result + (this.totalUnpaidInvoiceBalanceEqualsOrExceeds != null ? this.totalUnpaidInvoiceBalanceEqualsOrExceeds.hashCode() : 0);
        result = 31 * result + (this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds != null ? this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.responseForLastFailedPayment);
        result = 31 * result + (this.controlTagInclusion != null ? this.controlTagInclusion.hashCode() : 0);
        result = 31 * result + (this.controlTagExclusion != null ? this.controlTagExclusion.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultOverdueCondition{");
        sb.append("numberOfUnpaidInvoicesEqualsOrExceeds=").append(this.numberOfUnpaidInvoicesEqualsOrExceeds);
        sb.append(", totalUnpaidInvoiceBalanceEqualsOrExceeds=").append(this.totalUnpaidInvoiceBalanceEqualsOrExceeds);
        sb.append(", timeSinceEarliestUnpaidInvoiceEqualsOrExceeds=").append(this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds);
        sb.append(", responseForLastFailedPayment=").append(Arrays.toString(this.responseForLastFailedPayment));
        sb.append(", controlTagInclusion=").append(this.controlTagInclusion);
        sb.append(", controlTagExclusion=").append(this.controlTagExclusion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.numberOfUnpaidInvoicesEqualsOrExceeds != null);
        if (this.numberOfUnpaidInvoicesEqualsOrExceeds != null) {
            out.writeInt(this.numberOfUnpaidInvoicesEqualsOrExceeds);
        }
        out.writeObject(this.totalUnpaidInvoiceBalanceEqualsOrExceeds);
        out.writeObject(this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds);
        out.writeObject(this.responseForLastFailedPayment);
        out.writeBoolean(this.controlTagInclusion != null);
        if (this.controlTagInclusion != null) {
            out.writeUTF(this.controlTagInclusion.name());
        }
        out.writeBoolean(this.controlTagExclusion != null);
        if (this.controlTagExclusion != null) {
            out.writeUTF(this.controlTagExclusion.name());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.numberOfUnpaidInvoicesEqualsOrExceeds = in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        this.totalUnpaidInvoiceBalanceEqualsOrExceeds = (BigDecimal)in.readObject();
        this.timeSinceEarliestUnpaidInvoiceEqualsOrExceeds = (DefaultDuration)in.readObject();
        this.responseForLastFailedPayment = (PaymentResponse[])in.readObject();
        this.controlTagInclusion = in.readBoolean() ? ControlTagType.valueOf((String)in.readUTF()) : null;
        this.controlTagExclusion = in.readBoolean() ? ControlTagType.valueOf((String)in.readUTF()) : null;
    }
}

