/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.calculator;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceInternalApi;
import org.killbill.billing.overdue.config.api.BillingState;
import org.killbill.billing.overdue.config.api.OverdueException;
import org.killbill.billing.payment.api.PaymentResponse;
import org.killbill.billing.tag.TagInternalApi;
import org.killbill.billing.util.tag.Tag;
import org.killbill.clock.Clock;

public class BillingStateCalculator {
    private final InvoiceInternalApi invoiceApi;
    private final TagInternalApi tagApi;
    private final Clock clock;

    @Inject
    public BillingStateCalculator(InvoiceInternalApi invoiceApi, Clock clock, TagInternalApi tagApi) {
        this.invoiceApi = invoiceApi;
        this.clock = clock;
        this.tagApi = tagApi;
    }

    public BillingState calculateBillingState(ImmutableAccountData account, InternalCallContext context) throws OverdueException {
        SortedSet<Invoice> unpaidInvoices = this.unpaidInvoicesForAccount(account.getId(), context);
        int numberOfUnpaidInvoices = unpaidInvoices.size();
        BigDecimal unpaidInvoiceBalance = this.sumBalance(unpaidInvoices);
        LocalDate dateOfEarliestUnpaidInvoice = null;
        UUID idOfEarliestUnpaidInvoice = null;
        Invoice invoice = this.earliest(unpaidInvoices);
        if (invoice != null) {
            dateOfEarliestUnpaidInvoice = invoice.getInvoiceDate();
            idOfEarliestUnpaidInvoice = invoice.getId();
        }
        PaymentResponse responseForLastFailedPayment = PaymentResponse.INSUFFICIENT_FUNDS;
        List accountTags = this.tagApi.getTags(account.getId(), ObjectType.ACCOUNT, (InternalTenantContext)context);
        Tag[] tags = accountTags.toArray(new Tag[accountTags.size()]);
        return new BillingState(account.getId(), numberOfUnpaidInvoices, unpaidInvoiceBalance, dateOfEarliestUnpaidInvoice, idOfEarliestUnpaidInvoice, responseForLastFailedPayment, tags);
    }

    Invoice earliest(SortedSet<Invoice> unpaidInvoices) {
        try {
            return unpaidInvoices.first();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    BigDecimal sumBalance(SortedSet<Invoice> unpaidInvoices) {
        BigDecimal sum = BigDecimal.ZERO;
        for (Invoice unpaidInvoice : unpaidInvoices) {
            sum = sum.add(unpaidInvoice.getBalance());
        }
        return sum;
    }

    SortedSet<Invoice> unpaidInvoicesForAccount(UUID accountId, InternalCallContext context) {
        Collection invoices = this.invoiceApi.getUnpaidInvoicesByAccountId(accountId, context.toLocalDate(context.getCreatedDate()), (InternalTenantContext)context);
        TreeSet<Invoice> sortedInvoices = new TreeSet<Invoice>(new InvoiceDateComparator());
        sortedInvoices.addAll(invoices);
        return sortedInvoices;
    }

    protected class InvoiceDateComparator
    implements Comparator<Invoice> {
        protected InvoiceDateComparator() {
        }

        @Override
        public int compare(Invoice i1, Invoice i2) {
            LocalDate d2;
            LocalDate d1 = i1.getInvoiceDate();
            if (d1.compareTo((ReadablePartial)(d2 = i2.getInvoiceDate())) == 0) {
                return i1.hashCode() - i2.hashCode();
            }
            return d1.compareTo((ReadablePartial)d2);
        }
    }
}

