/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.applicator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.killbill.billing.events.BusEventBase;
import org.killbill.billing.events.BusInternalEvent;
import org.killbill.billing.events.OverdueChangeInternalEvent;

public class DefaultOverdueChangeEvent
extends BusEventBase
implements OverdueChangeInternalEvent {
    private final UUID overdueObjectId;
    private final String previousOverdueStateName;
    private final String nextOverdueStateName;
    private final Boolean isBlockedBilling;
    private final Boolean isUnblockedBilling;

    @JsonCreator
    public DefaultOverdueChangeEvent(@JsonProperty(value="overdueObjectId") UUID overdueObjectId, @JsonProperty(value="previousOverdueStateName") String previousOverdueStateName, @JsonProperty(value="nextOverdueStateName") String nextOverdueStateName, @JsonProperty(value="isBlockedBilling") Boolean isBlockedBilling, @JsonProperty(value="isUnblockedBilling") Boolean isUnblockedBilling, @JsonProperty(value="searchKey1") Long searchKey1, @JsonProperty(value="searchKey2") Long searchKey2, @JsonProperty(value="userToken") UUID userToken) {
        super(searchKey1, searchKey2, userToken);
        this.overdueObjectId = overdueObjectId;
        this.isBlockedBilling = isBlockedBilling;
        this.isUnblockedBilling = isUnblockedBilling;
        this.previousOverdueStateName = previousOverdueStateName;
        this.nextOverdueStateName = nextOverdueStateName;
    }

    @JsonIgnore
    public BusInternalEvent.BusInternalEventType getBusEventType() {
        return BusInternalEvent.BusInternalEventType.OVERDUE_CHANGE;
    }

    public String getPreviousOverdueStateName() {
        return this.previousOverdueStateName;
    }

    public UUID getOverdueObjectId() {
        return this.overdueObjectId;
    }

    public String getNextOverdueStateName() {
        return this.nextOverdueStateName;
    }

    @JsonProperty(value="isBlockedBilling")
    public Boolean isBlockedBilling() {
        return this.isBlockedBilling;
    }

    @JsonProperty(value="isUnblockedBilling")
    public Boolean isUnblockedBilling() {
        return this.isUnblockedBilling;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultOverdueChangeEvent{");
        sb.append("overdueObjectId=").append(this.overdueObjectId);
        sb.append(", previousOverdueStateName='").append(this.previousOverdueStateName).append('\'');
        sb.append(", nextOverdueStateName='").append(this.nextOverdueStateName).append('\'');
        sb.append(", isBlockedBilling=").append(this.isBlockedBilling);
        sb.append(", isUnblockedBilling=").append(this.isUnblockedBilling);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultOverdueChangeEvent)) {
            return false;
        }
        DefaultOverdueChangeEvent that = (DefaultOverdueChangeEvent)((Object)o);
        if (this.isBlockedBilling != null ? !this.isBlockedBilling.equals(that.isBlockedBilling) : that.isBlockedBilling != null) {
            return false;
        }
        if (this.isUnblockedBilling != null ? !this.isUnblockedBilling.equals(that.isUnblockedBilling) : that.isUnblockedBilling != null) {
            return false;
        }
        if (this.nextOverdueStateName != null ? !this.nextOverdueStateName.equals(that.nextOverdueStateName) : that.nextOverdueStateName != null) {
            return false;
        }
        if (this.overdueObjectId != null ? !this.overdueObjectId.equals(that.overdueObjectId) : that.overdueObjectId != null) {
            return false;
        }
        return !(this.previousOverdueStateName != null ? !this.previousOverdueStateName.equals(that.previousOverdueStateName) : that.previousOverdueStateName != null);
    }

    public int hashCode() {
        int result = this.overdueObjectId != null ? this.overdueObjectId.hashCode() : 0;
        result = 31 * result + (this.previousOverdueStateName != null ? this.previousOverdueStateName.hashCode() : 0);
        result = 31 * result + (this.nextOverdueStateName != null ? this.nextOverdueStateName.hashCode() : 0);
        result = 31 * result + (this.isBlockedBilling != null ? this.isBlockedBilling.hashCode() : 0);
        result = 31 * result + (this.isUnblockedBilling != null ? this.isUnblockedBilling.hashCode() : 0);
        return result;
    }
}

