/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.wrapper;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.api.OverdueConfig;
import org.killbill.billing.overdue.api.OverdueState;
import org.killbill.billing.overdue.caching.MockOverdueConfigCache;
import org.killbill.billing.overdue.config.DefaultOverdueConfig;
import org.killbill.billing.overdue.wrapper.OverdueWrapper;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestOverdueWrapper
extends OverdueTestSuiteWithEmbeddedDB {
    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeMethod();
        ((MockOverdueConfigCache)this.overdueConfigCache).loadOverwriteDefaultOverdueConfig(null);
    }

    @Test(groups={"slow"})
    public void testWrapperBasic() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        DefaultOverdueConfig config = (DefaultOverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, DefaultOverdueConfig.class);
        ((MockOverdueConfigCache)this.overdueConfigCache).loadOverwriteDefaultOverdueConfig((OverdueConfig)config);
        OverdueState state = config.getOverdueStatesAccount().findState("OD1");
        Account account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(31));
        OverdueWrapper wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account, (InternalTenantContext)this.internalCallContext);
        wrapper.refresh(this.clock.getUTCNow(), (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        state = config.getOverdueStatesAccount().findState("OD2");
        account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(41));
        wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account, (InternalTenantContext)this.internalCallContext);
        wrapper.refresh(this.clock.getUTCNow(), (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
        state = config.getOverdueStatesAccount().findState("OD3");
        account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(51));
        wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account, (InternalTenantContext)this.internalCallContext);
        wrapper.refresh(this.clock.getUTCNow(), (InternalCallContext)this.internalCallContext);
        this.testOverdueHelper.checkStateApplied(state);
    }

    @Test(groups={"slow"})
    public void testWrapperNoConfig() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.testOverdueHelper.getConfigXml().getBytes());
        DefaultOverdueConfig config = (DefaultOverdueConfig)XMLLoader.getObjectFromStreamNoValidation((InputStream)is, DefaultOverdueConfig.class);
        OverdueState state = config.getOverdueStatesAccount().findState("__KILLBILL__CLEAR__OVERDUE_STATE__");
        Account account = this.testOverdueHelper.createAccount(this.clock.getUTCToday().minusDays(31));
        OverdueWrapper wrapper = this.overdueWrapperFactory.createOverdueWrapperFor(account, (InternalTenantContext)this.internalCallContext);
        OverdueState result = wrapper.refresh(this.clock.getUTCNow(), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((String)result.getName(), (String)state.getName());
        Assert.assertEquals((boolean)result.isBlockChanges(), (boolean)state.isBlockChanges());
        Assert.assertEquals((boolean)result.isDisableEntitlementAndChangesBlocked(), (boolean)state.isDisableEntitlementAndChangesBlocked());
    }
}

