/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.notification;

import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.overdue.OverdueTestSuiteWithEmbeddedDB;
import org.killbill.billing.overdue.listener.OverdueDispatcher;
import org.killbill.billing.overdue.notification.OverdueCheckNotificationKey;
import org.killbill.billing.overdue.notification.OverdueCheckNotifier;
import org.killbill.billing.overdue.notification.OverdueNotifier;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestOverdueCheckNotifier
extends OverdueTestSuiteWithEmbeddedDB {
    private OverdueDispatcherMock mockDispatcher;
    private OverdueNotifier notifierForMock;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        this.cleanupAllTables();
        this.mockDispatcher = new OverdueDispatcherMock(this.internalCallContextFactory);
        this.notifierForMock = new OverdueCheckNotifier(this.notificationQueueService, this.overdueProperties, this.internalCallContextFactory, (OverdueDispatcher)this.mockDispatcher);
        this.notifierForMock.initialize();
        this.notifierForMock.start();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.notifierForMock.stop();
        super.afterMethod();
    }

    @Test(groups={"slow"})
    public void test() throws Exception {
        UUID accountId = new UUID(0L, 1L);
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getId()).thenReturn((Object)accountId);
        Mockito.when((Object)this.accountApi.getImmutableAccountDataByRecordId((Long)Mockito.eq((Object)this.internalCallContext.getAccountRecordId()), (InternalTenantContext)Mockito.any())).thenReturn((Object)account);
        DateTime now = this.clock.getUTCNow();
        DateTime readyTime = now.plusMillis(2000);
        OverdueCheckNotificationKey notificationKey = new OverdueCheckNotificationKey(accountId);
        this.checkPoster.insertOverdueNotification(accountId, readyTime, "overdue-check-queue", notificationKey, (InternalCallContext)this.internalCallContext);
        this.clock.setDeltaFromReality(3000L);
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return TestOverdueCheckNotifier.this.mockDispatcher.getEventCount() == 1;
            }
        });
        Assert.assertEquals((int)this.mockDispatcher.getEventCount(), (int)1);
        Assert.assertEquals((Object)this.mockDispatcher.getLatestAccountId(), (Object)accountId);
    }

    private static final class OverdueDispatcherMock
    extends OverdueDispatcher {
        int eventCount = 0;
        UUID latestAccountId = null;

        public OverdueDispatcherMock(InternalCallContextFactory internalCallContextFactory) {
            super(null);
        }

        public void processOverdueForAccount(UUID accountId, DateTime effectiveDate, InternalCallContext context) {
            ++this.eventCount;
            this.latestAccountId = accountId;
        }

        public int getEventCount() {
            return this.eventCount;
        }

        public UUID getLatestAccountId() {
            return this.latestAccountId;
        }
    }
}

