/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.overdue.glue;

import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.junction.BlockingInternalApi;
import org.killbill.billing.junction.DefaultBlockingState;
import org.killbill.billing.mock.glue.MockAccountModule;
import org.killbill.billing.mock.glue.MockEntitlementModule;
import org.killbill.billing.mock.glue.MockInvoiceModule;
import org.killbill.billing.mock.glue.MockTagModule;
import org.killbill.billing.mock.glue.MockTenantModule;
import org.killbill.billing.overdue.TestOverdueHelper;
import org.killbill.billing.overdue.applicator.OverdueBusListenerTester;
import org.killbill.billing.overdue.caching.MockOverdueConfigCache;
import org.killbill.billing.overdue.caching.OverdueCacheInvalidationCallback;
import org.killbill.billing.overdue.caching.OverdueConfigCache;
import org.killbill.billing.overdue.glue.DefaultOverdueModule;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.email.templates.TemplateModule;
import org.killbill.billing.util.glue.AuditModule;
import org.killbill.billing.util.glue.CacheModule;
import org.killbill.billing.util.glue.CallContextModule;
import org.killbill.billing.util.glue.ConfigModule;
import org.killbill.billing.util.glue.CustomFieldModule;
import org.killbill.billing.util.glue.MemoryGlobalLockerModule;

public class TestOverdueModule
extends DefaultOverdueModule {
    public TestOverdueModule(KillbillConfigSource configSource) {
        super(configSource);
    }

    protected void configure() {
        super.configure();
        this.install((Module)new AuditModule(this.configSource));
        this.install((Module)new CacheModule(this.configSource));
        this.install((Module)new ConfigModule(this.configSource));
        this.install((Module)new CallContextModule(this.configSource));
        this.install((Module)new CustomFieldModule(this.configSource));
        this.install((Module)new MockAccountModule(this.configSource));
        this.install((Module)new MockEntitlementModule(this.configSource, (BlockingInternalApi)new ApplicatorBlockingApi()));
        this.install((Module)new MockInvoiceModule(this.configSource));
        this.install((Module)new MockTagModule(this.configSource, true));
        this.install((Module)new TemplateModule(this.configSource));
        this.install((Module)new MockTenantModule(this.configSource));
        this.install((Module)new MemoryGlobalLockerModule(this.configSource));
        this.bind(OverdueBusListenerTester.class).asEagerSingleton();
        this.bind(TestOverdueHelper.class).asEagerSingleton();
    }

    public void installOverdueConfigCache() {
        this.bind(OverdueConfigCache.class).to(MockOverdueConfigCache.class).asEagerSingleton();
        this.bind(TenantInternalApi.CacheInvalidationCallback.class).annotatedWith((Annotation)Names.named((String)"overdueInvalidationCallback")).to(OverdueCacheInvalidationCallback.class).asEagerSingleton();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ApplicatorBlockingApi
    implements BlockingInternalApi {
        private BlockingState blockingState;

        public BlockingState getBlockingState() {
            return this.blockingState;
        }

        public BlockingState getBlockingStateForService(UUID blockableId, BlockingStateType blockingStateType, String serviceName, InternalTenantContext context) {
            if (this.blockingState != null && this.blockingState.getBlockedId().equals(blockableId)) {
                return this.blockingState;
            }
            return new DefaultBlockingState(null, blockingStateType, "__KILLBILL__CLEAR__OVERDUE_STATE__", serviceName, false, false, false, null);
        }

        public List<BlockingState> getBlockingAllForAccount(Catalog catalog, InternalTenantContext context) {
            throw new UnsupportedOperationException();
        }

        public void setBlockingState(BlockingState state, InternalCallContext context) {
            this.blockingState = state;
        }
    }
}

